/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DoubleCList {
    Group _group;
    Composite groupWidget;
    public CList sourceList;
    public CList targetList;
    public Label targetListLabel;
    public Label sourceListLabel;
    public Button add;
    public Button remove;
    public Button addAll;
    public Button removeAll;
    public Button moveUp;
    public Button moveDown;
    private ArrayList listeners = new ArrayList();
    private ListSelListener lstListener = null;

    public DoubleCList(Composite parent, int style, String groupText, String sourceTextID, String targetTextID) {
        this._group = new Group(parent, style);
        this._group.setText(groupText);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = -10;
        layout.horizontalSpacing = 0;
        this._group.setLayout((Layout)layout);
        this._group.setLayoutData((Object)GridUtil.createFill());
        this.createDoubleList((Composite)this._group, sourceTextID, targetTextID);
        ButtonListener btnListener = new ButtonListener();
        this.add.addSelectionListener((SelectionListener)btnListener);
        this.remove.addSelectionListener((SelectionListener)btnListener);
        this.addAll.addSelectionListener((SelectionListener)btnListener);
        this.removeAll.addSelectionListener((SelectionListener)btnListener);
        this.moveUp.addSelectionListener((SelectionListener)btnListener);
        this.moveDown.addSelectionListener((SelectionListener)btnListener);
        this.lstListener = new ListSelListener();
        this.sourceList.addSelectionListener(this.lstListener);
        this.targetList.addSelectionListener(this.lstListener);
        this.updateButtons();
    }

    private void addItems(CList list, List items) {
        int i = 0;
        while (i < items.size()) {
            Object item = items.get(i);
            if (item != null && !item.toString().trim().equals("")) {
                list.add(item);
            }
            ++i;
        }
    }

    public void addSourceItem(String item) {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(item);
        this.addItems(this.sourceList, items);
    }

    public void addSourceItems(List items) {
        this.addItems(this.sourceList, items);
    }

    public void addTargetItem(String item) {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(item);
        this.addItems(this.targetList, items);
    }

    public void addTargetItems(List items) {
        this.addItems(this.targetList, items);
    }

    public void createDoubleList(Composite parent, String sourceTextID, String targetTextID) {
        this.groupWidget = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.groupWidget.setLayout((Layout)layout);
        this.sourceList = new CList(this.groupWidget, sourceTextID);
        this.sourceList.getList().setLayoutData((Object)GridUtil.createFill());
        Composite buttonWidget = new Composite(this.groupWidget, 0);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        Label label = new Label(buttonWidget, 8);
        label.setText("");
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.add = new Button(buttonWidget, 8);
        this.add.setText(LogUIPlugin.getResourceString("LEFT_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.add.setLayoutData((Object)spec);
        this.remove = new Button(buttonWidget, 8);
        this.remove.setText(LogUIPlugin.getResourceString("RIGHT_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.remove.setLayoutData((Object)spec);
        new Label(buttonWidget, 0);
        this.addAll = new Button(buttonWidget, 8);
        this.addAll.setText(LogUIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.addAll.setLayoutData((Object)spec);
        this.removeAll = new Button(buttonWidget, 8);
        this.removeAll.setText(LogUIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.removeAll.setLayoutData((Object)spec);
        Label label1 = new Label(buttonWidget, 8);
        label1.setText("");
        spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.targetList = new CList(this.groupWidget, targetTextID);
        this.targetList.getList().setLayoutData((Object)GridUtil.createFill());
        Composite button2Widget = new Composite(this.groupWidget, 0);
        blayout = new GridLayout();
        blayout.numColumns = 1;
        button2Widget.setLayout((Layout)blayout);
        label = new Label(button2Widget, 8);
        label.setText("");
        spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.moveUp = new Button(button2Widget, 8);
        this.moveUp.setText(LogUIPlugin.getResourceString("MOVEUP_TEXT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.moveUp.setLayoutData((Object)spec);
        this.moveDown = new Button(button2Widget, 8);
        this.moveDown.setText(LogUIPlugin.getResourceString("MOVEDOWN_TEXT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.moveDown.setLayoutData((Object)spec);
    }

    public void initializeSourceList(ArrayList arrayList) {
        Object[] list = arrayList.toArray();
        int idx = 0;
        while (idx < list.length) {
            this.sourceList.add(list[idx].toString());
            ++idx;
        }
        if (arrayList.size() > 0) {
            this.sourceList.setSelectedIndex(0);
        }
    }

    public void initializeTargetList(ArrayList arrayList) {
        Object[] list = arrayList.toArray();
        int idx = 0;
        while (idx < list.length) {
            this.targetList.add(list[idx].toString());
            ++idx;
        }
    }

    public void enable(boolean enable) {
        this._group.setEnabled(enable);
        this.add.setEnabled(enable);
        this.addAll.setEnabled(enable);
        this.remove.setEnabled(enable);
        this.removeAll.setEnabled(enable);
        this.moveUp.setEnabled(enable);
        this.moveDown.setEnabled(enable);
        this.sourceList.enable(enable);
        this.targetList.enable(enable);
    }

    public Object findInList(CList list, Object obj) {
        int i = 0;
        while (i < list.getList().getItemCount()) {
            Object item = list.getItem(i);
            if (this.itemsEqual(item, obj)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private List getItems(CList list) {
        ArrayList<Object> items = new ArrayList<Object>();
        int i = 0;
        while (i < list.getList().getItemCount()) {
            Object item = list.getItem(i);
            if (item != null && !item.toString().trim().equals("")) {
                items.add(item);
            }
            ++i;
        }
        return items;
    }

    public List getSourceItems() {
        return this.getItems(this.sourceList);
    }

    public List getTargetItems() {
        return this.getItems(this.targetList);
    }

    public String getText() {
        return this.getTargetItems().toString();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    private boolean isInList(CList list, Object obj) {
        int i = 0;
        while (i < list.getList().getItemCount()) {
            Object item = list.getItem(i);
            if (this.itemsEqual(item, obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInSourceList(Object obj) {
        return this.isInList(this.sourceList, obj);
    }

    public boolean isInTargetList(Object obj) {
        return this.isInList(this.targetList, obj);
    }

    private boolean itemsEqual(Object item1, Object item2) {
        return item1.toString().equals(item2.toString());
    }

    public void removeAll() {
        this.targetList.getList().removeAll();
        this.sourceList.getList().removeAll();
    }

    private void removeFromList(CList list, Object obj) {
        int i = 0;
        while (i < list.getList().getItemCount()) {
            Object item = this.findInList(list, obj);
            if (item != null) {
                list.remove(item);
            }
            ++i;
        }
    }

    public void removeFromSource(Object obj) {
        this.removeFromList(this.sourceList, obj);
    }

    public void removeFromTarget(Object obj) {
        this.removeFromList(this.targetList, obj);
    }

    public void setEnabled(boolean b) {
        this.targetList.getList().setEnabled(b);
        this.sourceList.getList().setEnabled(b);
    }

    public void setFocus() {
        this.sourceList.setFocus();
    }

    public void setToolTipText(String text) {
        this.sourceList.setToolTipText(text);
        this.targetList.setToolTipText(text);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
        this.sourceList.removeSelectionListener(this.lstListener);
        this.targetList.removeSelectionListener(this.lstListener);
    }

    public void fireSelectionNotification(SelectionEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
            ++i;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int items = this.targetList.getItemCount();
        int[] selection = this.targetList.getSelectedIndices();
        if (selection.length == 0) {
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
        } else {
            int min = items - 1;
            int max = 0;
            int i = 0;
            while (i < selection.length) {
                min = Math.min(selection[i], min);
                max = Math.max(selection[i], max);
                ++i;
            }
            this.moveUp.setEnabled(min > 0);
            this.moveDown.setEnabled(max < items - 1);
        }
    }

    class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == DoubleCList.this.add) {
                String[] items = DoubleCList.this.sourceList.getSelectedItems();
                int i = 0;
                while (i < items.length) {
                    DoubleCList.this.targetList.add(items[i]);
                    DoubleCList.this.sourceList.remove(items[i]);
                    ++i;
                }
                DoubleCList.this.sourceList.clearSelection();
            } else if (e.widget == DoubleCList.this.addAll) {
                int i = 0;
                while (i < DoubleCList.this.sourceList.getList().getItemCount()) {
                    Object item = DoubleCList.this.sourceList.getItem(i);
                    DoubleCList.this.targetList.add(item);
                    ++i;
                }
                DoubleCList.this.sourceList.getList().removeAll();
            } else if (e.widget == DoubleCList.this.remove) {
                String[] items = DoubleCList.this.targetList.getSelectedItems();
                int i = 0;
                while (i < items.length) {
                    DoubleCList.this.sourceList.add(items[i]);
                    DoubleCList.this.targetList.remove(items[i]);
                    ++i;
                }
                DoubleCList.this.targetList.clearSelection();
            } else if (e.widget == DoubleCList.this.removeAll) {
                int i = 0;
                while (i < DoubleCList.this.targetList.getList().getItemCount()) {
                    Object item = DoubleCList.this.targetList.getItem(i);
                    DoubleCList.this.sourceList.add(item);
                    ++i;
                }
                DoubleCList.this.targetList.getList().removeAll();
            } else if (e.widget == DoubleCList.this.moveUp) {
                int[] indices = DoubleCList.this.targetList.getSelectedIndices();
                Arrays.sort(indices);
                int i = 0;
                while (i < indices.length) {
                    String oldStr = DoubleCList.this.targetList.getList().getItem(indices[i] - 1);
                    String newStr = DoubleCList.this.targetList.getList().getItem(indices[i]);
                    DoubleCList.this.targetList.getList().setItem(indices[i] - 1, newStr);
                    DoubleCList.this.targetList.getList().setItem(indices[i], oldStr);
                    int n = i++;
                    indices[n] = indices[n] - 1;
                }
                DoubleCList.this.targetList.getList().setSelection(indices);
            } else if (e.widget == DoubleCList.this.moveDown) {
                int[] indices = DoubleCList.this.targetList.getSelectedIndices();
                Arrays.sort(indices);
                int i = indices.length - 1;
                while (i >= 0) {
                    String oldStr = DoubleCList.this.targetList.getList().getItem(indices[i] + 1);
                    String newStr = DoubleCList.this.targetList.getList().getItem(indices[i]);
                    DoubleCList.this.targetList.getList().setItem(indices[i] + 1, newStr);
                    DoubleCList.this.targetList.getList().setItem(indices[i], oldStr);
                    int n = i--;
                    indices[n] = indices[n] + 1;
                }
                DoubleCList.this.targetList.getList().setSelection(indices);
            }
            e.data = new Integer(4);
            DoubleCList.this.fireSelectionNotification(e);
        }
    }

    class ListSelListener
    implements SelectionListener {
        ListSelListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == DoubleCList.this.sourceList.getList() && DoubleCList.this.sourceList.getSelectedItem() != null) {
                DoubleCList.this.targetList.clearSelection();
            } else if (e.widget == DoubleCList.this.targetList.getList() && DoubleCList.this.targetList.getSelectedItem() != null) {
                DoubleCList.this.sourceList.clearSelection();
            }
            if (e.widget != DoubleCList.this.sourceList.getList() && e.widget != DoubleCList.this.targetList.getList()) {
                if (e.data != DoubleCList.this.sourceList) {
                    e.data = new Integer(4);
                }
                DoubleCList.this.fireSelectionNotification(e);
            }
            DoubleCList.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object item;
            if (e.widget == DoubleCList.this.sourceList.getList()) {
                Object item2 = DoubleCList.this.sourceList.getSelectedItem();
                if (item2 != null) {
                    DoubleCList.this.sourceList.remove(item2);
                    DoubleCList.this.targetList.add(item2);
                    DoubleCList.this.sourceList.clearSelection();
                }
            } else if (e.widget == DoubleCList.this.targetList.getList() && (item = DoubleCList.this.targetList.getSelectedItem()) != null) {
                DoubleCList.this.targetList.remove(item);
                DoubleCList.this.sourceList.add(item);
                DoubleCList.this.targetList.clearSelection();
            }
            e.data = new Integer(4);
            DoubleCList.this.fireSelectionNotification(e);
        }
    }
}

