/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.SymptomDBSelectionGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBSelectionDialog
extends SelectionDialog
implements ISelectionValidator,
Listener {
    private SymptomDBSelectionGroup group;
    private boolean onlyMonitorFolders = true;
    private int style;
    private int type;
    private Label statusMessage;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 300;

    public SymptomDBSelectionDialog(Shell parentShell, String message) {
        this(parentShell, message, 0, 1);
    }

    public SymptomDBSelectionDialog(Shell parentShell, String message, int style, int type) {
        super(parentShell);
        this.setTitle(LogUIPlugin.getResourceString("STR_MON_SEL_TITLE"));
        this.style = style;
        this.type = type;
        this.onlyMonitorFolders = true;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(LogUIPlugin.getResourceString("STR_MON_SEL_TEXT"));
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
        this.statusMessage.setText(LogUIPlugin.getResourceString("STR_MON_SEL_TEXT"));
        this.getOkButton().setEnabled(false);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.group = new SymptomDBSelectionGroup(dialogArea, this, true);
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(1808));
        WorkbenchHelp.setHelp((Control)dialogArea, (String)ContextIds.SYMDB_PREF_DATABASE_ADD_DIALOG);
        return dialogArea;
    }

    public void handleEvent(Event event) {
        if (this.statusMessage != null) {
            String errorMsg = this.isValid(this.group.getContainerFullPath());
            if (errorMsg == null || errorMsg.equals("")) {
                this.statusMessage.setText("");
                this.getOkButton().setEnabled(true);
            } else {
                this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
                this.statusMessage.setText(errorMsg);
                this.getOkButton().setEnabled(false);
            }
        }
    }

    public String isValid(Object selection) {
        IPath path = (IPath)selection;
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res != null && res instanceof IContainer) {
            return LogUIPlugin.getResourceString("STR_MON_SEL_TEXT");
        }
        return null;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        chosenContainerPathList.add(this.group.getContainerFullPath());
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    public void setShowOnlyMonitorFolders(boolean value) {
        this.onlyMonitorFolders = value;
    }
}

