/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.log.ui.internal.navigator.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogSelectionWizardPage
extends WizardPage
implements SelectionListener {
    private DoubleList doubleList;
    private IStructuredSelection sel;
    private Text txtName;
    private Set existingCorrNames;

    protected LogSelectionWizardPage(String pageName, IStructuredSelection sel) {
        super(pageName);
        this.setTitle(LogUIPlugin.getResourceString("STR_LOGSEL_PAGE_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("STR_LOGSEL_PAGE_DESC"));
        this.setImageDescriptor(LogUIPluginImages.getImageDescriptor("newcorrelation.gif"));
        this.sel = sel;
    }

    public void createControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 370;
        composite.setLayoutData((Object)data);
        this.createNameGroup(composite);
        this.doubleList = new DoubleList(composite, 0, LogUIPlugin.getResourceString("STR_AVAILABLE_LOGS"), LogUIPlugin.getResourceString("STR_SELECTED_LOGS"));
        this.doubleList.createControl();
        this.initializeValues();
        this.doubleList.addSelectionListener(this);
        this.setControl((Control)composite);
    }

    public String getName() {
        return this.txtName.getText();
    }

    public List getLogFiles() {
        return this.doubleList.getTargetItems();
    }

    private void createNameGroup(Composite composite) {
        Composite locationGrp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        GridData data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        locationGrp.setLayout((Layout)layout);
        locationGrp.setLayoutData((Object)data);
        Label lblName = new Label(locationGrp, 0);
        data = new GridData();
        lblName.setLayoutData((Object)data);
        lblName.setText(LogUIPlugin.getResourceString("STR_NEW_CORR_NAME"));
        this.txtName = new Text(locationGrp, 2048);
        data = GridUtil.createHorizontalFill();
        this.txtName.setLayoutData((Object)data);
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        this.txtName.setText("NewCorrelation (" + (store.getInt("corr_nr") + 1) + ")");
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LogSelectionWizardPage.this.existingCorrNames != null && LogSelectionWizardPage.this.existingCorrNames.contains(LogSelectionWizardPage.this.txtName.getText())) {
                    LogSelectionWizardPage.this.setErrorMessage(LogUIPlugin.getResourceString("STR_CORR_EXISTS_MSG"));
                } else {
                    LogSelectionWizardPage.this.setErrorMessage(null);
                }
                LogSelectionWizardPage.this.setPageComplete(LogSelectionWizardPage.this.isPageComplete());
            }
        });
        WorkbenchHelp.setHelp((Control)this.txtName, (String)ContextIds.NEW_CORR_WIZARD_CORRNAME);
    }

    private void initializeValues() {
        List source = new ArrayList();
        ArrayList target = new ArrayList();
        source = this.populateLogFilesList();
        this.doubleList.removeAll();
        this.doubleList.initializeSourceList(source);
        this.doubleList.initializeTargetList(target);
        if (this.sel != null && !this.sel.isEmpty()) {
            Object element = null;
            Iterator iter = this.sel.iterator();
            while (iter.hasNext()) {
                element = iter.next();
                if (element == null || !(element instanceof TRCAgentProxy)) continue;
                this.doubleList.getSourceItems().remove(element);
                this.doubleList.getTargetItems().add(element);
            }
            this.doubleList.refreshViews();
        }
    }

    private List populateLogFilesList() {
        IWorkbenchPage page = null;
        IViewPart navigator = null;
        IWorkbenchWindow[] windows = LogUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                page = pages[j];
                if (page != null && (navigator = page.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator")) != null) break;
                ++j;
            }
            ++i;
        }
        ArrayList logList = new ArrayList();
        if (navigator != null && navigator instanceof LogNavigator) {
            logList.addAll(EMFUtil.getLogAgentsFromResourceSet((ResourceSet)HierarchyResourceSetImpl.getInstance()));
            this.loadCorrelationContainerProxyNames(((LogNavigator)navigator).getContentProvider());
        } else {
            logList.addAll(this.loadLogFiles());
        }
        return logList;
    }

    private void loadCorrelationContainerProxyNames(LogContentProvider provider) {
        if (this.existingCorrNames == null) {
            this.existingCorrNames = new HashSet();
        }
        if (provider != null) {
            Object[] correlations = provider.getChildren(provider.getCorrelationFolder());
            int i = 0;
            while (i < correlations.length) {
                this.existingCorrNames.add(((CorrelationContainerProxy)correlations[i]).getName());
                ++i;
            }
        }
    }

    private List loadLogFiles(Object[] eObjects) {
        int size = eObjects.length;
        ArrayList<TRCAgentProxy> log_agents = new ArrayList<TRCAgentProxy>();
        int idx = 0;
        while (idx < size) {
            Object obj = eObjects[idx];
            if (obj instanceof TRCMonitor) {
                this.appendCorrelationContainerProxyNames((List)((TRCMonitor)obj).getCorrelationContainerProxies());
                EList nodes = ((TRCMonitor)obj).getNodes();
                int nodes_size = nodes.size();
                int i = 0;
                while (i < nodes_size) {
                    EList processes = ((TRCNode)nodes.get(i)).getProcessProxies();
                    int j = 0;
                    while (j < processes.size()) {
                        EList agents = ((TRCProcessProxy)processes.get(j)).getAgentProxies();
                        int k = 0;
                        while (k < agents.size()) {
                            TRCAgentProxy agent = (TRCAgentProxy)agents.get(k);
                            if (agent.getType().equals("Logging")) {
                                log_agents.add(agent);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ++idx;
        }
        return log_agents;
    }

    private void appendCorrelationContainerProxyNames(List list) {
        if (this.existingCorrNames == null) {
            this.existingCorrNames = new HashSet();
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CorrelationContainerProxy element = (CorrelationContainerProxy)iter.next();
            if (this.existingCorrNames.contains(element.getName())) continue;
            this.existingCorrNames.add(element.getName());
        }
    }

    private List loadLogFiles() {
        String[] extensions = new String[]{"trcmxmi"};
        Map filesByExtension = ResourceUtil.getFiles((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot(), (String[])extensions, null);
        Object[] resourceSetObj = EMFUtil.loadMonitorsFromResourceSet((ResourceSet)HierarchyResourceSetImpl.getInstance());
        ArrayList log_agents = new ArrayList();
        log_agents.addAll(this.loadLogFiles(resourceSetObj));
        Iterator i = ((List)filesByExtension.get("trcmxmi")).iterator();
        while (i.hasNext()) {
            Object[] eObjects = EMFUtil.load((ResourceSet)HierarchyResourceSetImpl.getInstance(), (IFile)i.next());
            Iterator iter = this.loadLogFiles(eObjects).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (log_agents.contains(element)) continue;
                log_agents.add(element);
            }
        }
        return log_agents;
    }

    public void widgetSelected(SelectionEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean isPageComplete() {
        return this.doubleList.getTargetItems().size() > 0 && this.txtName.getText().length() > 0 && this.existingCorrNames != null && !this.existingCorrNames.contains(this.txtName.getText());
    }

    public void dispose() {
        this.doubleList.removeSelectionListener(this);
        if (this.existingCorrNames != null) {
            this.existingCorrNames.clear();
        }
        super.dispose();
    }

    class DoubleList {
        Group group;
        Composite groupWidget;
        private TableViewer sourceList;
        private TableViewer targetList;
        private Label targetListLabel;
        private Label sourceListLabel;
        private List sourceContent = new ArrayList();
        private List targetContent = new ArrayList();
        private Button add;
        private Button remove;
        private Button addAll;
        private Button removeAll;
        private List listeners = new ArrayList(2);
        private TableLabelProvider labelProvider;
        private Composite parent;
        private int style;
        private String sourceText;
        private String targetText;

        public DoubleList(Composite parent, int style, String sourceText, String targetText) {
            this.parent = parent;
            this.style = style;
            this.sourceText = sourceText;
            this.targetText = targetText;
        }

        public Control createControl() {
            this.group = new Group(this.parent, this.style);
            this.group.setText("");
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)GridUtil.createFill());
            this.createDoubleList((Composite)this.group, this.sourceText, this.targetText);
            WidgetListener listener = new WidgetListener();
            this.add.addSelectionListener((SelectionListener)listener);
            this.remove.addSelectionListener((SelectionListener)listener);
            this.addAll.addSelectionListener((SelectionListener)listener);
            this.removeAll.addSelectionListener((SelectionListener)listener);
            this.sourceList.getTable().addSelectionListener((SelectionListener)listener);
            this.targetList.getTable().addSelectionListener((SelectionListener)listener);
            WorkbenchHelp.setHelp((Control)this.sourceList.getTable(), (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.targetList.getTable(), (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            return this.group;
        }

        public void refreshViews() {
            this.sourceList.refresh();
            this.targetList.refresh();
        }

        public void createDoubleList(Composite parent, String sourceText, String targetText) {
            this.groupWidget = parent;
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.groupWidget.setLayout((Layout)layout);
            this.createTableGroup(this.groupWidget, sourceText, true);
            this.createButtonGroup(this.groupWidget);
            this.createTableGroup(this.groupWidget, targetText, false);
            this.labelProvider = new TableLabelProvider();
        }

        public void initializeSourceList(List source) {
            this.sourceContent.addAll(source);
            this.sourceList.setContentProvider((IContentProvider)new TableContentProvider());
            this.sourceList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.sourceList.setInput((Object)this.sourceContent);
            if (source.size() > 0) {
                this.sourceList.setSelection((ISelection)new StructuredSelection(source.get(0)));
            }
        }

        public void initializeTargetList(List target) {
            this.targetContent.addAll(target);
            this.targetList.setContentProvider((IContentProvider)new TableContentProvider());
            this.targetList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.targetList.setInput((Object)this.targetContent);
        }

        public void removeAll() {
            this.targetContent.clear();
            this.sourceContent.clear();
        }

        public List getSourceItems() {
            return this.sourceContent;
        }

        public List getTargetItems() {
            return this.targetContent;
        }

        public void addSelectionListener(SelectionListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.listeners.remove(listener);
        }

        public void fireSelectionNotification(SelectionEvent e) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
                ++i;
            }
        }

        private void createTableGroup(Composite parent, String text, boolean source) {
            Composite tableGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            tableGroup.setLayout((Layout)layout);
            tableGroup.setLayoutData((Object)GridUtil.createFill());
            Label label = new Label(tableGroup, 0);
            label.setText(text);
            GridData spec = new GridData();
            spec.horizontalAlignment = 4;
            label.setLayoutData((Object)spec);
            if (source) {
                this.sourceList = new TableViewer(this.createTable(tableGroup));
                this.sourceList.getTable().setLayoutData((Object)GridUtil.createFill());
            } else {
                this.targetList = new TableViewer(this.createTable(tableGroup));
                this.targetList.getTable().setLayoutData((Object)GridUtil.createFill());
            }
        }

        private Table createTable(Composite parent) {
            Table table = new Table(parent, 68356);
            GridData tblData = GridUtil.createFill();
            tblData.heightHint = 75;
            tblData.widthHint = 150;
            table.setLayoutData((Object)tblData);
            TableColumn column0 = new TableColumn(table, 0);
            TableColumn column1 = new TableColumn(table, 0);
            ColumnWeightData c0Layout = new ColumnWeightData(0, false);
            ColumnWeightData c1Layout = new ColumnWeightData(1, true);
            TableLayout tblLayout = new TableLayout();
            tblLayout.addColumnData((ColumnLayoutData)c0Layout);
            tblLayout.addColumnData((ColumnLayoutData)c1Layout);
            table.setLayout((Layout)tblLayout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            return table;
        }

        private void createButtonGroup(Composite groupWidget) {
            Composite buttonGroup = new Composite(groupWidget, 0);
            GridLayout blayout = new GridLayout();
            blayout.numColumns = 1;
            buttonGroup.setLayout((Layout)blayout);
            Label label = new Label(buttonGroup, 8);
            label.setText("");
            GridData spec = new GridData();
            spec.grabExcessVerticalSpace = true;
            spec.verticalAlignment = 4;
            label.setLayoutData((Object)spec);
            this.add = new Button(buttonGroup, 8);
            this.add.setText(LogUIPlugin.getResourceString("LEFT_TO_RIGHT"));
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.add.setLayoutData((Object)spec);
            this.remove = new Button(buttonGroup, 8);
            this.remove.setText(LogUIPlugin.getResourceString("RIGHT_TO_LEFT"));
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.remove.setLayoutData((Object)spec);
            new Label(buttonGroup, 0);
            this.addAll = new Button(buttonGroup, 8);
            this.addAll.setText(LogUIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.addAll.setLayoutData((Object)spec);
            this.removeAll = new Button(buttonGroup, 8);
            this.removeAll.setText(LogUIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.removeAll.setLayoutData((Object)spec);
            Label label1 = new Label(buttonGroup, 8);
            label1.setText("");
            spec = new GridData();
            spec.grabExcessVerticalSpace = true;
            spec.verticalAlignment = 4;
            label.setLayoutData((Object)spec);
            WorkbenchHelp.setHelp((Control)this.add, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.remove, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.addAll, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
            WorkbenchHelp.setHelp((Control)this.removeAll, (String)ContextIds.NEW_CORR_WIZARD_LOGS);
        }

        class TableLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private LogLabelProvider logLabelProvider = new LogLabelProvider();

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return this.logLabelProvider.getImage(element);
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    return this.logLabelProvider.getText(element);
                }
                return "";
            }

            public void dispose() {
                super.dispose();
            }
        }

        class TableContentProvider
        implements IStructuredContentProvider {
            private List tableContents = new ArrayList(0);

            TableContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                return this.tableContents.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.tableContents = (List)newInput;
            }
        }

        class WidgetListener
        implements SelectionListener {
            WidgetListener() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Object item;
                Iterator i;
                IStructuredSelection sel;
                if (e.widget == DoubleList.this.sourceList.getTable() && !DoubleList.this.sourceList.getSelection().isEmpty()) {
                    sel = (IStructuredSelection)DoubleList.this.sourceList.getSelection();
                    i = sel.iterator();
                    while (i.hasNext()) {
                        item = i.next();
                        DoubleList.this.targetContent.add(item);
                        DoubleList.this.sourceContent.remove(item);
                    }
                    DoubleList.this.sourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                    DoubleList.this.refreshViews();
                    DoubleList.this.fireSelectionNotification(e);
                }
                if (e.widget == DoubleList.this.targetList.getTable() && !DoubleList.this.targetList.getSelection().isEmpty()) {
                    sel = (IStructuredSelection)DoubleList.this.targetList.getSelection();
                    i = sel.iterator();
                    while (i.hasNext()) {
                        item = i.next();
                        DoubleList.this.sourceContent.add(item);
                        DoubleList.this.targetContent.remove(item);
                    }
                    DoubleList.this.targetList.setSelection((ISelection)StructuredSelection.EMPTY);
                    DoubleList.this.refreshViews();
                    DoubleList.this.fireSelectionNotification(e);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] sel;
                if (e.widget == DoubleList.this.add) {
                    IStructuredSelection sel2 = (IStructuredSelection)DoubleList.this.sourceList.getSelection();
                    Iterator i = sel2.iterator();
                    while (i.hasNext()) {
                        Object item = i.next();
                        DoubleList.this.targetContent.add(item);
                        DoubleList.this.sourceContent.remove(item);
                    }
                    DoubleList.this.sourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                } else if (e.widget == DoubleList.this.addAll) {
                    int i = 0;
                    while (i < DoubleList.this.sourceContent.size()) {
                        Object item = DoubleList.this.sourceContent.get(i);
                        DoubleList.this.targetContent.add(item);
                        ++i;
                    }
                    DoubleList.this.sourceContent.clear();
                } else if (e.widget == DoubleList.this.remove) {
                    IStructuredSelection sel3 = (IStructuredSelection)DoubleList.this.targetList.getSelection();
                    Iterator i = sel3.iterator();
                    while (i.hasNext()) {
                        Object item = i.next();
                        DoubleList.this.sourceContent.add(item);
                        DoubleList.this.targetContent.remove(item);
                    }
                    DoubleList.this.targetList.setSelection((ISelection)StructuredSelection.EMPTY);
                } else if (e.widget == DoubleList.this.removeAll) {
                    int i = 0;
                    while (i < DoubleList.this.targetContent.size()) {
                        Object item = DoubleList.this.targetContent.get(i);
                        DoubleList.this.sourceContent.add(item);
                        ++i;
                    }
                    DoubleList.this.targetContent.clear();
                } else if (e.widget instanceof Table && (sel = ((Table)e.widget).getSelection()) != null && sel.length > 0) {
                    ((Table)e.widget).setToolTipText(sel[0].getText());
                }
                DoubleList.this.refreshViews();
                DoubleList.this.fireSelectionNotification(e);
            }
        }
    }
}

