/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import sun.security.action.GetPropertyAction;

public class FileUtil {
    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim().replace('\\', '/')).endsWith("/") && !path.endsWith("//")) {
            path = path.substring(0, path.length() - "/".length());
        }
        return path;
    }

    public static String appendPath(String path1, String path2) {
        path1 = FileUtil.normalizePath(path1);
        path2 = FileUtil.normalizePath(path2);
        if (path1 == null || path1.trim().length() == 0) {
            return path2;
        }
        if (path2 == null || path2.trim().length() == 0) {
            return path1;
        }
        if (path1.endsWith("//")) {
            if (path2.startsWith("/") && path2.length() > 1) {
                path2 = path2.substring(1);
            }
        } else if (!path2.startsWith("/")) {
            path2 = "/" + path2;
        }
        return path1 + path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int totalBytes = 0;
                int length = 0;
                byte[] buffer = new byte[256];
                while ((length = inputStream.read(buffer)) != -1) {
                    totalBytes += length;
                    outputStream.write(buffer, 0, length);
                }
                return totalBytes;
            }
        }
    }

    public static String removeLastSegment(String path) {
        int index = (path = FileUtil.normalizePath(path)).lastIndexOf("/");
        if (index < 0) {
            return "";
        }
        return path.substring(0, index);
    }

    public static String getLastSegment(String path) {
        int index = (path = FileUtil.normalizePath(path)).lastIndexOf("/");
        if (index >= 0) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static File getValidFileOrDirectory(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return file.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException ioE) {
            return null;
        }
    }

    public static boolean writeToFile(String encoding, File file, boolean append, String text) {
        File validFile;
        if (file == null) {
            return false;
        }
        if (!append && (validFile = FileUtil.getValidFileOrDirectory(file)) != null && file.isFile() && file.exists()) {
            validFile.delete();
            file = validFile;
        }
        if (text == null || text.length() == 0) {
            return true;
        }
        try {
            return FileUtil.writeToOutputStream(encoding, new FileOutputStream(file.toString(), append), text);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeToOutputStream(String encoding, OutputStream outputStream, String text) {
        try {
            OutputStreamWriter out = null;
            try {
                out = encoding != null ? new OutputStreamWriter(outputStream, encoding) : new OutputStreamWriter(outputStream);
                out.write(text);
                ((Writer)out).flush();
                Object var5_5 = null;
                if (outputStream == null) return true;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return true;
        }
        catch (IOException ioE) {
            return false;
        }
    }

    public static String readFromFile(String encoding, File file, boolean keepOpen) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return FileUtil.readFromInputStream(encoding, new FileInputStream(file), keepOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String readFromInputStream(String encoding, InputStream inputStream, boolean keepOpen) throws IOException {
        String string;
        block3: {
            StringBuffer buffer = new StringBuffer();
            try {
                int ch;
                InputStreamReader isr = null;
                isr = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
                BufferedReader in = new BufferedReader(isr);
                while ((ch = ((Reader)in).read()) > -1) {
                    void var6_6;
                    buffer.append((char)var6_6);
                }
                string = buffer.toString();
                Object var9_8 = null;
                if (keepOpen || inputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_9 = null;
                    if (keepOpen || inputStream == null) break block4;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map getZipEntryDataByZipEntryName(String zipFileName) {
        Hashtable<String, Integer> entrySizeByEntryName = new Hashtable<String, Integer>();
        Hashtable<String, byte[]> entryDataByEntryName = new Hashtable<String, byte[]>();
        try {
            ZipEntry entry;
            block13: {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(zipFileName);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (true) {
                        if (!e.hasMoreElements()) {
                            Object var7_7 = null;
                            if (zipFile == null) break block13;
                            break;
                        }
                        entry = e.nextElement();
                        entrySizeByEntryName.put(entry.getName(), new Integer((int)entry.getSize()));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
            }
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFileName)));
                entry = zipInputStream.getNextEntry();
                while (true) {
                    if (entry == null) {
                        Object var11_13 = null;
                        if (zipInputStream == null) return entryDataByEntryName;
                        break;
                    }
                    if (!entry.isDirectory()) {
                        int size = (int)entry.getSize();
                        if (size == -1) {
                            size = (Integer)entrySizeByEntryName.get(entry.getName());
                        }
                        byte[] data = new byte[size];
                        int offset = 0;
                        int ret = 0;
                        while (size - offset > 0 && (ret = zipInputStream.read(data, offset, size - offset)) != -1) {
                            offset += ret;
                        }
                        entryDataByEntryName.put(entry.getName(), data);
                    }
                    entry = zipInputStream.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (zipInputStream == null) throw throwable;
                zipInputStream.close();
                throw throwable;
            }
            zipInputStream.close();
            return entryDataByEntryName;
        }
        catch (Exception e) {
            return entryDataByEntryName;
        }
    }

    public static String getFileExtension(File file) {
        if (file == null || file.isDirectory()) {
            return "";
        }
        return FileUtil.getFileExtension(file.getName());
    }

    public static String getFileExtension(String file) {
        if (file == null) {
            return "";
        }
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        if (index == file.length() - 1) {
            return "";
        }
        return file.substring(index + 1);
    }

    public static boolean isParent(File parentCandidate, File fileToAnalyse) {
        if (fileToAnalyse == null || parentCandidate == null) {
            return false;
        }
        parentCandidate = parentCandidate.getAbsoluteFile();
        fileToAnalyse = fileToAnalyse.getAbsoluteFile();
        while (fileToAnalyse != null) {
            if (parentCandidate.equals(fileToAnalyse)) {
                return true;
            }
            fileToAnalyse = fileToAnalyse.getParentFile();
        }
        return false;
    }

    public static File getTempDir() {
        GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
        String tmpdir = AccessController.doPrivileged(a);
        return new File(tmpdir);
    }

    public static int delete(File file) {
        if (file.isFile()) {
            return file.delete() ? 1 : 0;
        }
        if (file.isDirectory()) {
            int counter = 0;
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                counter += FileUtil.delete(files[i]);
                ++i;
            }
            return counter += file.delete() ? 1 : 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFiles(File[] files, File toDirectory, boolean overwrite) throws IOException {
        if (files == null || files.length == 0 || toDirectory == null) {
            return 0;
        }
        if (toDirectory.exists()) {
            if (!toDirectory.isDirectory()) {
                return 0;
            }
        } else {
            toDirectory.mkdirs();
        }
        int copyCount = 0;
        int i = 0;
        int max = files.length;
        while (i < max) {
            block11: {
                Object var10_9;
                File newFile;
                block13: {
                    block12: {
                        if (files[i] == null || !files[i].exists() || !files[i].isFile()) break block11;
                        newFile = new File(toDirectory, files[i].getName());
                        if (newFile.exists() && newFile.isFile()) break block12;
                        newFile.createNewFile();
                        break block13;
                    }
                    if (!overwrite) break block11;
                }
                FileInputStream inputStream = new FileInputStream(files[i]);
                FileOutputStream outputStream = new FileOutputStream(newFile);
                try {
                    FileUtil.streamCopy(inputStream, outputStream);
                    ++copyCount;
                    var10_9 = null;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    inputStream.close();
                    outputStream.close();
                    throw throwable;
                }
                inputStream.close();
                outputStream.close();
                {
                }
            }
            ++i;
        }
        return copyCount;
    }
}

