/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SourceInfoViewer
implements ModifyListener,
SelectionListener {
    private StyledText packageText;
    private StyledText classNameText;
    private Button packageButton;
    private IImplementor implementor;
    private VerifyKeyListener verifyKeyListener;

    public void dispose() {
        this.implementor = null;
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected IImplementor getImplementor() {
        return this.implementor;
    }

    public Composite createClient(Composite composite, VerifyKeyListener verifyKeyListener, WidgetFactory widgetFactory) {
        this.verifyKeyListener = verifyKeyListener;
        Composite composite2 = null;
        composite2 = widgetFactory != null ? widgetFactory.createComposite(composite) : new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        if (widgetFactory != null) {
            widgetFactory.createLabel(composite2, TestJavaPlugin.getString("STR_WB_PACK"));
        } else {
            new Label(composite2, 0).setText(TestJavaPlugin.getString("STR_WB_PACK"));
        }
        this.packageText = widgetFactory != null ? widgetFactory.createStyledText(composite2, 65540) : new StyledText(composite2, 67588);
        this.packageText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.packageText.setEditable(false);
        if (widgetFactory != null) {
            this.packageButton = widgetFactory.createButton(composite2, TestJavaPlugin.getString("STR_WB_PACK_BTN"), 8);
        } else {
            this.packageButton = new Button(composite2, 8);
            this.packageButton.setText(TestJavaPlugin.getString("STR_WB_PACK_BTN"));
        }
        this.packageButton.setLayoutData((Object)new GridData(128));
        this.packageButton.addSelectionListener((SelectionListener)this);
        if (widgetFactory != null) {
            widgetFactory.createLabel(composite2, TestJavaPlugin.getString("STR_WB_CLASS"));
        } else {
            new Label(composite2, 0).setText(TestJavaPlugin.getString("STR_WB_CLASS"));
        }
        this.classNameText = widgetFactory != null ? widgetFactory.createStyledText(composite2, 65540) : new StyledText(composite2, 67588);
        this.classNameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.classNameText.setEditable(false);
        if (widgetFactory != null) {
            widgetFactory.paintBordersFor(composite2);
        }
        return composite2;
    }

    public void setInput(Object object) {
        IStructuredSelection iStructuredSelection;
        this.implementor = null;
        if (object instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)object).size() == 1) {
            object = iStructuredSelection.getFirstElement();
        }
        if (object instanceof ITest) {
            object = ((ITest)object).getImplementor();
        }
        if (object != null && object instanceof IImplementor) {
            this.implementor = (IImplementor)object;
            this.adjustTexts();
            this.packageText.setEditable(true);
            this.classNameText.setEditable(true);
        } else {
            this.packageText.setText("");
            this.classNameText.setText("");
            this.packageText.setEditable(false);
            this.classNameText.setEditable(false);
        }
    }

    protected void adjustTexts() {
        if (this.verifyKeyListener != null) {
            this.packageText.removeVerifyKeyListener(this.verifyKeyListener);
            this.classNameText.removeVerifyKeyListener(this.verifyKeyListener);
        }
        this.packageText.removeModifyListener((ModifyListener)this);
        this.classNameText.removeModifyListener((ModifyListener)this);
        String string = "";
        String string2 = "";
        String string3 = this.getImplementor().getResource();
        if (string3 != null) {
            int n = string3.lastIndexOf(46);
            if (n >= 0) {
                string2 = string3.substring(0, n);
            } else {
                n = -1;
            }
            if (n != string3.length() - 1) {
                string = string3.substring(n + 1);
            }
        }
        this.packageText.setText(string2);
        this.classNameText.setText(string);
        if (this.verifyKeyListener != null) {
            this.packageText.addVerifyKeyListener(this.verifyKeyListener);
            this.classNameText.addVerifyKeyListener(this.verifyKeyListener);
        }
        this.packageText.addModifyListener((ModifyListener)this);
        this.classNameText.addModifyListener((ModifyListener)this);
    }

    public Object getInput() {
        return this.getImplementor();
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getImplementor() == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.getImplementor());
    }

    public void selectReveal(ISelection iSelection) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.classNameText || modifyEvent.widget == this.packageText) {
            String string = this.getPackage();
            String string2 = this.getClassName();
            if (string.length() > 0 && string2.length() > 0) {
                this.getImplementor().setResource(string + "." + string2);
            } else {
                this.getImplementor().setResource(string + string2);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        selectionEvent.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.isReadOnly()) {
            selectionEvent.doit = false;
        } else if (selectionEvent.widget == this.packageButton) {
            ElementTreeSelectionDialog elementTreeSelectionDialog = TestJavaUtil.createPackageDialog(this.packageButton.getShell(), false);
            elementTreeSelectionDialog.setTitle(TestJavaPlugin.getString("TITLE_PACK_SELECT"));
            elementTreeSelectionDialog.setMessage(TestJavaPlugin.getString("STR_PACK_SELECT"));
            elementTreeSelectionDialog.setEmptyListMessage(TestJavaPlugin.getString("NO_PACK"));
            if (elementTreeSelectionDialog.open() == 0) {
                IPackageFragment iPackageFragment = (IPackageFragment)elementTreeSelectionDialog.getResult()[0];
                Object object = null;
                object = iPackageFragment.getParent() == null ? iPackageFragment.getParent().getJavaProject().getProject() : iPackageFragment.getParent().getResource();
                if (object != null) {
                    this.getImplementor().setLocation(object.getFullPath().toString());
                }
                this.packageText.setText(iPackageFragment.getElementName());
            }
        }
    }

    public String getPackage() {
        return this.packageText.getText().trim();
    }

    public String getClassName() {
        return this.classNameText.getText().trim();
    }

    public void setInitialFocus() {
        if (this.packageText != null) {
            this.packageText.setFocus();
        }
    }
}

