/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.provider.AdapterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.provider.FormatterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.provider.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.AdaptorEditor;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.ConfigurationPage;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.MigrationUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class AdaptorEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener {
    IFile file;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected RuleBuilderWidgetFactory widgetFactory;
    protected ConfigurationPage detailsViewer;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == AdaptorEditor.this.contentOutlinePage) {
                    AdaptorEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)AdaptorEditor.this);
                    AdaptorEditor.this.setCurrentViewer((Viewer)AdaptorEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == AdaptorEditor.this.propertySheetPage) {
                    AdaptorEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)AdaptorEditor.this);
                    AdaptorEditor.this.handleActivate();
                }
            } else if (p == AdaptorEditor.this) {
                AdaptorEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ResourceSet resourceSet = AdaptorEditor.this.editingDomain.getResourceSet();
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection changedResources;
                    protected Collection removedResources;
                    private final /* synthetic */ 2 this$1;

                    ResourceDeltaVisitor(2 this$1) {
                        this.this$1 = this$1;
                        this.resourceSet = 2.access$000(this.this$1).editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<E>();
                        this.removedResources = new ArrayList<E>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this);
                delta.accept((IResourceDeltaVisitor)visitor);
                AdaptorEditor.this.removedResources.addAll(visitor.getRemovedResources());
                if (!visitor.getRemovedResources().isEmpty() && !AdaptorEditor.this.isDirty()) {
                    AdaptorEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            2.access$000(this.this$1).getSite().getPage().closeEditor((IEditorPart)2.access$000(this.this$1), false);
                            2.access$000(this.this$1).dispose();
                        }
                    });
                }
                AdaptorEditor.this.changedResources.addAll(visitor.getChangedResources());
            }
            catch (CoreException exception) {
                AcadEditorPlugin.INSTANCE.log((Object)exception);
            }
        }

        static /* synthetic */ AdaptorEditor access$000(2 x0) {
            return x0.AdaptorEditor.this;
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    protected void handleActivate() {
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            Iterator i = this.changedResources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    AcadEditorPlugin.INSTANCE.log(exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)AdaptorEditor.getString("_UI_FileConflict_label"), (String)AdaptorEditor.getString("_WARN_FileConflict"));
    }

    public AdaptorEditor() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add((Object)new ConfigurationItemProviderAdapterFactory());
        factories.add((Object)new ExtractorItemProviderAdapterFactory());
        factories.add((Object)new ContextItemProviderAdapterFactory());
        factories.add((Object)new OutputterItemProviderAdapterFactory());
        factories.add((Object)new SensorItemProviderAdapterFactory());
        factories.add((Object)new AdapterItemProviderAdapterFactory());
        factories.add((Object)new ParserItemProviderAdapterFactory());
        factories.add((Object)new FormatterItemProviderAdapterFactory());
        factories.add((Object)new UnitItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                AdaptorEditor.this.getContainer().getDisplay().asyncExec(new Runnable(this, event){
                    private final /* synthetic */ EventObject val$event;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        4.access$100(this.this$1).firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)this.val$event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            4.access$100(this.this$1).setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if (4.access$100(this.this$1).propertySheetPage != null && !4.access$100(this.this$1).propertySheetPage.getControl().isDisposed()) {
                            4.access$100(this.this$1).propertySheetPage.refresh();
                        }
                    }
                });
            }

            static /* synthetic */ AdaptorEditor access$100(4 x0) {
                return x0.AdaptorEditor.this;
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (AdaptorEditor.this.currentViewer != null) {
                        AdaptorEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        AdaptorEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    public void createPages() {
        this.widgetFactory = new RuleBuilderWidgetFactory();
        IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
        try {
            String fileName = URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString()).toString();
            Resource resource = this.editingDomain.getResourceSet().getResource(URI.createURI((String)fileName), true);
        }
        catch (Exception exception) {
            AcadEditorPlugin.INSTANCE.log(exception);
        }
        ScrolledComposite viewForm = new ScrolledComposite(this.getContainer(), 768);
        viewForm.setExpandHorizontal(true);
        viewForm.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        viewForm.setLayout((Layout)layout);
        this.detailsViewer = new ConfigurationPage(this.widgetFactory, (EditingDomain)this.editingDomain);
        viewForm.setContent(this.detailsViewer.getContent((Composite)viewForm));
        Point p = this.detailsViewer.getContent().computeSize(-1, -1);
        viewForm.setMinWidth(p.x);
        viewForm.setMinHeight(p.y);
        int pageIndex = this.addPage((Control)viewForm);
        this.setPageText(pageIndex, "First page");
        this.selectionViewer = this.detailsViewer.getViewer();
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        EList list = this.editingDomain.getResourceSet().getResources();
        if (list.size() > 0) {
            Object selected = list.get(0);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Resource element = (Resource)iter.next();
                if (!element.getURI().fileExtension().equals("adapter")) continue;
                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                EObject rootObject = (EObject)element.getContents().get(0);
                selected = rootObject;
                try {
                    MigrationUtil.migrateLoad((AdapterType)rootObject.eGet(eStructuralFeature));
                }
                catch (Exception e) {}
                break;
            }
            this.selectionViewer.setInput(selected);
        } else {
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
        }
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
        this.addSelectionChangedListener(this.detailsViewer);
        this.setCurrentViewer((Viewer)this.selectionViewer);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    AdaptorEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            ((CTabFolder)this.getContainer()).setTabHeight(1);
            Point point = this.getContainer().getSize();
            this.getContainer().setSize(point.x, point.y + 2);
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        Control control = this.getControl(pageIndex);
        if (control != null) {
            control.setVisible(true);
            control.setFocus();
        }
        this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
    }

    public Object getAdapter(Class key) {
        if (key.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = AdaptorEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = AdaptorEditor.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                private final /* synthetic */ AdaptorEditor this$0;

                MyContentOutlinePage(AdaptorEditor this$0) {
                    this.this$0 = this$0;
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    this.this$0.contentOutlineViewer = this.getTreeViewer();
                    this.this$0.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    this.this$0.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.this$0.adapterFactory));
                    this.this$0.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.this$0.adapterFactory));
                    this.this$0.contentOutlineViewer.setInput((Object)this.this$0.editingDomain.getResourceSet());
                    this.this$0.createContextMenuFor((StructuredViewer)this.this$0.contentOutlineViewer);
                    if (!this.this$0.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ArrayList<Object> selection = new ArrayList<Object>();
                        selection.add(this.this$0.editingDomain.getResourceSet().getResources().get(0));
                        this.this$0.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    this.this$0.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    this.this$0.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage(this);
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AdaptorEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    AdaptorEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    Resource savedResource = (Resource)AdaptorEditor.this.editingDomain.getResourceSet().getResources().get(0);
                    try {
                        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                        EObject rootObject = (EObject)savedResource.getContents().get(0);
                        AdapterType adapter = (AdapterType)rootObject.eGet(eStructuralFeature);
                        MigrationUtil.migrateSave(adapter);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    AdaptorEditor.this.savedResources.add(savedResource);
                    savedResource.save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    AcadEditorPlugin.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            AcadEditorPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setTitle(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setTitle(((IFileEditorInput)editorInput).getFile().getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.file = ((IFileEditorInput)editorInput).getFile();
        this.enableEditActions();
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        Object[] listeners = this.selectionChangedListeners.toArray();
        int idx = 0;
        while (idx < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[idx];
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            ++idx;
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (this.currentViewer == this.contentOutlineViewer) {
            statusLineManager = this.contentOutlineStatusLineManager;
        }
        if (selection instanceof IStructuredSelection) {
            List collection = ((IStructuredSelection)selection).toList();
            switch (collection.size()) {
                case 0: {
                    statusLineManager.setMessage(AdaptorEditor.getString("_UI_NoObjectSelected"));
                    break;
                }
                case 1: {
                    String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                    statusLineManager.setMessage(AdaptorEditor.getString("_UI_SingleObjectSelected", text));
                    break;
                }
                default: {
                    statusLineManager.setMessage(AdaptorEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                    break;
                }
            }
        } else {
            statusLineManager.setMessage("");
        }
    }

    private static String getString(String key) {
        return AcadEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return AcadEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        AcadGuiModelManager.disposeModel(this.file);
        this.file = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        this.getActionBarContributor().setActiveEditor(null);
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

