/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EObjectResourceContentProvider
implements ITreeContentProvider {
    private String[] fileExtensions;
    public static final int FILTER_FOLDERS = 2;
    public static final int SHOW_ALL = 4;
    private int filter;
    private ArrayList list = new ArrayList();

    public EObjectResourceContentProvider(String[] fileExtensions) {
        if (fileExtensions == null || fileExtensions.length == 0) {
            throw new IllegalArgumentException();
        }
        this.fileExtensions = fileExtensions;
    }

    public int getFilter() {
        return this.filter;
    }

    public void setFilter(int filter) {
        this.filter = filter;
    }

    public void dispose() {
        this.list.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            switch (this.filter) {
                case 4: {
                    IFile file = EMFUtil.getWorkspaceFile(eObject);
                    if (file == null) break;
                    return file.getParent();
                }
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            if (this.getFilter() == 2) {
                this.list.clear();
                IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
                int idx = 0;
                while (idx < projects.length) {
                    Object[] children = this.getChildren(projects[idx]);
                    int i = 0;
                    while (i < children.length) {
                        this.list.add(children[i]);
                        ++i;
                    }
                    ++idx;
                }
                return this.list.toArray();
            }
            return ((IWorkspaceRoot)inputElement).getProjects();
        }
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            UniqueEList children = new UniqueEList();
            IResource[] resources = null;
            try {
                resources = ((IContainer)parentElement).members();
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                return new Object[0];
            }
            int i = 0;
            int maxi = resources.length;
            while (i < maxi) {
                if (resources[i].getType() != 1) {
                    if (this.filter == 2) {
                        Object[] tmpArray = this.getChildren(resources[i]);
                        int k = 0;
                        while (k < tmpArray.length) {
                            children.add(tmpArray[k]);
                            ++k;
                        }
                    } else {
                        children.add(resources[i]);
                    }
                } else {
                    IFile file = (IFile)resources[i];
                    int j = 0;
                    while (j < this.fileExtensions.length) {
                        if (file.getFileExtension().equals(this.fileExtensions[j])) {
                            EObject[] eObjects = EMFUtil.load(null, (IFile)resources[i]);
                            int idx = 0;
                            while (idx < eObjects.length) {
                                EObject eObject = eObjects[idx];
                                children.add(eObject);
                                ++idx;
                            }
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return children.toArray();
        }
        if (parentElement instanceof Resource) {
            return ((Resource)parentElement).getContents().toArray();
        }
        return new Object[0];
    }
}

