/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NamedElementSection
extends EditorSection
implements ModifyListener {
    private StyledText nameText;
    private StyledText descriptionText;
    private CMNNamedElement namedElement;

    public NamedElementSection(EditorForm editorForm) {
        super(editorForm);
        this.setCollapsable(true);
    }

    public void dispose() {
        this.namedElement = null;
        super.dispose();
    }

    protected CMNNamedElement getNamedElement() {
        return this.namedElement;
    }

    public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_NAME"));
        this.nameText = widgetFactory.createStyledText(composite, 65540);
        this.nameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.nameText.setEditable(false);
        this.addCenterControls(composite, widgetFactory);
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_DESC"));
        this.descriptionText = widgetFactory.createStyledText(composite, 66114);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.heightHint = 4 * this.descriptionText.getLineHeight();
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setEditable(false);
        this.addSouthControls(composite, widgetFactory);
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    protected void addCenterControls(Composite parent, FormWidgetFactory formWidgetFactory) {
    }

    protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
    }

    protected void addCenterControls(Composite parent, WidgetFactory widgetFactory) {
        this.addCenterControls(parent, (FormWidgetFactory)widgetFactory);
    }

    protected void addSouthControls(Composite parent, WidgetFactory widgetFactory) {
        this.addSouthControls(parent, (FormWidgetFactory)widgetFactory);
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.namedElement = null;
        this.nameText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.nameText.removeModifyListener((ModifyListener)this);
        this.descriptionText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.descriptionText.removeModifyListener((ModifyListener)this);
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof CMNNamedElement) {
            this.namedElement = (CMNNamedElement)object;
            String value = this.getNamedElement().getName();
            if (value != null) {
                this.nameText.setText(value);
            } else {
                this.nameText.setText("");
            }
            value = this.getNamedElement().getDescription();
            if (value != null) {
                this.descriptionText.setText(value);
            } else {
                this.descriptionText.setText("");
            }
            this.nameText.setEditable(true);
            this.descriptionText.setEditable(true);
        } else {
            this.nameText.setText("");
            this.descriptionText.setText("");
            this.nameText.setEditable(false);
            this.descriptionText.setEditable(false);
        }
        this.nameText.addVerifyKeyListener((VerifyKeyListener)this);
        this.nameText.addModifyListener((ModifyListener)this);
        this.descriptionText.addVerifyKeyListener((VerifyKeyListener)this);
        this.descriptionText.addModifyListener((ModifyListener)this);
    }

    public Object getInput() {
        return this.namedElement;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.namedElement == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.namedElement);
    }

    public void selectReveal(ISelection selection) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.nameText) {
            this.getNamedElement().setName(this.nameText.getText());
            this.getEditorForm().updateTitle();
            this.getEditorForm().getBaseEditorExtension().markDirty();
        } else if (e.widget == this.descriptionText) {
            this.getNamedElement().setDescription(this.descriptionText.getText());
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    protected StyledText getNameTextField() {
        return this.nameText;
    }

    protected StyledText getDescriptionTextField() {
        return this.descriptionText;
    }
}

