/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;

public class DefaultDeploymentsProvider
implements IDeploymentsProvider {
    private CFGClass theTestElement;
    private List deploymentsList;

    private void findDeployments(Object resource) {
        IFile file;
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    this.findDeployments(members[i]);
                    ++i;
                }
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
        } else if (resource instanceof IFile && "deploy".equals((file = (IFile)resource).getFileExtension())) {
            EObject[] eobjs = EMFUtil.load(null, file);
            int i = 0;
            while (i < eobjs.length) {
                if (eobjs[i] instanceof TPFDeployment && this.isDeploymentApplicable((TPFDeployment)eobjs[i])) {
                    this.deploymentsList.add(eobjs[i]);
                }
                ++i;
            }
        }
    }

    public TPFDeployment[] getDeployments(Object testElement) {
        this.deploymentsList = new ArrayList();
        if (testElement instanceof TPFTestSuite || testElement instanceof TPFTestComponent) {
            this.theTestElement = (CFGClass)testElement;
        } else if (testElement instanceof TPFTestCase) {
            this.theTestElement = ((TPFTestCase)testElement).getTestSuite();
        }
        this.findDeployments(ResourcesPlugin.getWorkspace().getRoot());
        TPFDeployment[] result = new TPFDeployment[this.deploymentsList.size()];
        return this.deploymentsList.toArray(result);
    }

    public TPFDeployment getDefaultDeployment(Object testElement) {
        TPFDeployment[] deployments = this.getDeployments(testElement);
        if (deployments.length > 0) {
            return deployments[0];
        }
        return null;
    }

    private boolean isDeploymentApplicable(TPFDeployment deployment) {
        if (ConfigurationUtil.isDefaultLocation((TPFDeployment)deployment)) {
            return true;
        }
        CFGArtifactLocationPair pair = ConfigurationUtil.searchPairWithTestAsset((CFGClass)this.theTestElement, (TPFDeployment)deployment);
        if (pair != null) {
            return pair.getLocation() != null;
        }
        return false;
    }
}

