/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.DefaultDeploymentsProvider;
import org.eclipse.hyades.test.ui.internal.launch.extensions.DefaultExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider2;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;
import org.eclipse.hyades.test.ui.launch.extensions.ITestLaunchConfigurationValidator;

public class LaunchConfigurationExtensionsManager {
    private static LaunchConfigurationExtensionsManager instance;
    private static final String KIND_TEST = "test";
    private static final String KIND_COMPONENT = "testComponent";
    private Map testExtensionMap = new HashMap();
    private Map componentExtensionMap = new HashMap();
    private Map launchConfigurationMap = new HashMap();
    private IDeploymentsProvider defaultDeploymentsProvider = new DefaultDeploymentsProvider();
    private IExecutionHistoryDefaultsProvider defaultExecutionHistoryDefaultsProvider = new DefaultExecutionHistoryDefaultsProvider();

    public static LaunchConfigurationExtensionsManager getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationExtensionsManager();
        }
        return instance;
    }

    private LaunchConfigurationExtensionsManager() {
        this.registerRunHandlers();
        this.registerDeploymentsProviders();
        this.registerExecutionHistoryDefaultsProviders();
        this.registerExecutionHistoryDefaults2Providers();
        this.registerSupportedTestTypes();
        this.registerLaunchConfigurationValidators();
    }

    private TestExtensionDescriptor getExtensionDescriptor(String type, String kind) {
        Assert.isNotNull((Object)kind);
        Assert.isNotNull((Object)type);
        Map map = null;
        if (kind.equals(KIND_TEST)) {
            map = this.testExtensionMap;
        } else if (kind.equals(KIND_COMPONENT)) {
            map = this.componentExtensionMap;
        } else {
            throw new IllegalArgumentException("Invalid kind");
        }
        Assert.isNotNull((Object)map);
        Object o = map.get(type);
        if (o == null) {
            o = new TestExtensionDescriptor();
            map.put(type, o);
        }
        return (TestExtensionDescriptor)o;
    }

    private TestExtensionDescriptor getTestExtensionDescriptor(Object testElement) {
        if (testElement != null) {
            TPFTestComponent testComponent;
            if (testElement instanceof TPFTest) {
                TPFTest test = (TPFTest)testElement;
                if (test.getType() != null) {
                    return this.getExtensionDescriptor(test.getType(), KIND_TEST);
                }
            } else if (testElement instanceof TPFTestComponent && (testComponent = (TPFTestComponent)testElement).getType() != null) {
                return this.getExtensionDescriptor(testComponent.getType(), KIND_COMPONENT);
            }
        }
        return null;
    }

    private LaunchConfigurationExtensionDescriptor getLaunchConfigurationExtensionDescriptor(String launchConfigurationType) {
        Assert.isNotNull((Object)launchConfigurationType);
        Object o = this.launchConfigurationMap.get(launchConfigurationType);
        if (o == null) {
            o = new LaunchConfigurationExtensionDescriptor();
            this.launchConfigurationMap.put(launchConfigurationType, o);
        }
        return (LaunchConfigurationExtensionDescriptor)o;
    }

    private void registerRunHandlers() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".runHandler");
        if (extPoint != null) {
            IConfigurationElement[] runHandlers = extPoint.getConfigurationElements();
            int i = 0;
            while (i < runHandlers.length) {
                IConfigurationElement[] supportedTypes = runHandlers[i].getChildren();
                int j = 0;
                while (j < supportedTypes.length) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.runHandlerConfigElem = runHandlers[i];
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + runHandlers[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void registerExecutionHistoryDefaultsProviders() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryDefaults");
        if (extPoint != null) {
            IConfigurationElement[] defaultsProviders = extPoint.getConfigurationElements();
            int i = 0;
            while (i < defaultsProviders.length) {
                IConfigurationElement[] supportedStuff = defaultsProviders[i].getChildren();
                int j = 0;
                while (j < supportedStuff.length) {
                    String type = supportedStuff[j].getAttribute("type");
                    String kind = supportedStuff[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.execHistoryDefaultsProviderConfigElem = defaultsProviders[i];
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + defaultsProviders[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void registerExecutionHistoryDefaults2Providers() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryDefaults2");
        if (extPoint != null) {
            IConfigurationElement[] defaultsProviders = extPoint.getConfigurationElements();
            int i = 0;
            while (i < defaultsProviders.length) {
                IConfigurationElement[] supportedStuff = defaultsProviders[i].getChildren();
                int j = 0;
                while (j < supportedStuff.length) {
                    String type = supportedStuff[j].getAttribute("type");
                    try {
                        LaunchConfigurationExtensionDescriptor ed = this.getLaunchConfigurationExtensionDescriptor(type);
                        ed.execHistoryDefaultsProviderConfigElem = defaultsProviders[i];
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + defaultsProviders[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void registerDeploymentsProviders() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".deploymentProvider");
        if (extPoint != null) {
            IConfigurationElement[] deploymentProviders = extPoint.getConfigurationElements();
            int i = 0;
            while (i < deploymentProviders.length) {
                IConfigurationElement[] supportedTypes = deploymentProviders[i].getChildren();
                int j = 0;
                while (j < supportedTypes.length) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.deploymentsProviderConfigElem = deploymentProviders[i];
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + deploymentProviders[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void registerLaunchConfigurationValidators() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".launchConfigValidator");
        if (extPoint != null) {
            IConfigurationElement[] launchConfigurationValidators = extPoint.getConfigurationElements();
            int i = 0;
            while (i < launchConfigurationValidators.length) {
                IConfigurationElement[] supportedTypes = launchConfigurationValidators[i].getChildren();
                int j = 0;
                while (j < supportedTypes.length) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.launchConfigurationValidatorConfigElem = launchConfigurationValidators[i];
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + launchConfigurationValidators[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void registerSupportedTestTypes() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".launchableType");
        if (extPoint != null) {
            IConfigurationElement[] supportedTypes = extPoint.getConfigurationElements();
            int i = 0;
            while (i < supportedTypes.length) {
                String type = supportedTypes[i].getAttribute("type");
                String kind = supportedTypes[i].getAttribute("kind");
                String lcType = supportedTypes[i].getAttribute("launchConfigurationType");
                try {
                    TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                    ed.launchConfigurationType = lcType;
                    IConfigurationElement[] supportedModes = supportedTypes[i].getChildren();
                    int j = 0;
                    while (j < supportedModes.length) {
                        String mode = supportedModes[j].getAttribute("mode");
                        boolean shortcutAvailable = "true".equals(supportedModes[j].getAttribute("shortcutAvailable"));
                        ed.supportedLaunchModes.add(mode);
                        if (shortcutAvailable) {
                            ed.availableShortcutModes.add(mode);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    TestUIPlugin.logError("Extension " + supportedTypes[i].getName() + " was ignored. See next messages for details.");
                    TestUIPlugin.logError(e);
                }
                ++i;
            }
        }
    }

    public IRunHandler getRunHandler(Object testElement) {
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            return ed.getRunHandler();
        }
        return null;
    }

    public IExecutionHistoryDefaultsProvider getExecutionHistoryDefaultsProvider(Object testElement) {
        IExecutionHistoryDefaultsProvider result = null;
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            result = ed.getExecutionHistoryDefaultsProvider();
        }
        if (result == null) {
            result = this.defaultExecutionHistoryDefaultsProvider;
        }
        return result;
    }

    public IExecutionHistoryDefaultsProvider2 getExecutionHistoryDefaultsProvider2(String launchConfigurationType) {
        IExecutionHistoryDefaultsProvider2 result = null;
        LaunchConfigurationExtensionDescriptor ed = this.getLaunchConfigurationExtensionDescriptor(launchConfigurationType);
        if (ed != null) {
            result = ed.getExecutionHistoryDefaultsProvider();
        }
        return result;
    }

    public IDeploymentsProvider getDeploymentsProvider(Object testElement) {
        IDeploymentsProvider result = null;
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            result = ed.getDeploymentsProvider();
        }
        if (result == null) {
            result = this.defaultDeploymentsProvider;
        }
        return result;
    }

    public ITestLaunchConfigurationValidator getLaunchConfigurationValidator(Object testElement) {
        ITestLaunchConfigurationValidator result = null;
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            result = ed.getLaunchConfigurationValidator();
        }
        return result;
    }

    public boolean isLaunchableElement(Object testElement, String mode, String launchConfigurationType) {
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            return ed.isLaunchConfigurationTypeSupported(launchConfigurationType) && ed.supportedLaunchModes.contains(mode);
        }
        return false;
    }

    public boolean isShortcutAvailable(Object testElement, String mode) {
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            return ed.launchConfigurationType == null && ed.availableShortcutModes.contains(mode);
        }
        return false;
    }

    public IExecutionHistoryDefaultsProvider getDefaultExecutionHistoryDefaultsProvider() {
        return this.defaultExecutionHistoryDefaultsProvider;
    }

    public IDeploymentsProvider getDefaultDeploymentsProvider() {
        return this.defaultDeploymentsProvider;
    }

    private class LaunchConfigurationExtensionDescriptor {
        public IConfigurationElement execHistoryDefaultsProviderConfigElem = null;
        private IExecutionHistoryDefaultsProvider2 execHistoryDefaultsProvider = null;

        private LaunchConfigurationExtensionDescriptor() {
        }

        public IExecutionHistoryDefaultsProvider2 getExecutionHistoryDefaultsProvider() {
            block2: {
                if (this.execHistoryDefaultsProvider != null || this.execHistoryDefaultsProviderConfigElem == null) break block2;
                try {
                    this.execHistoryDefaultsProvider = (IExecutionHistoryDefaultsProvider2)this.execHistoryDefaultsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.execHistoryDefaultsProviderConfigElem = null;
                }
            }
            return this.execHistoryDefaultsProvider;
        }
    }

    private class TestExtensionDescriptor {
        public IConfigurationElement runHandlerConfigElem = null;
        private IRunHandler runHandler = null;
        public List supportedLaunchModes = new ArrayList(3);
        public List availableShortcutModes = new ArrayList(3);
        public String launchConfigurationType = null;
        public IConfigurationElement execHistoryDefaultsProviderConfigElem = null;
        private IExecutionHistoryDefaultsProvider execHistoryDefaultsProvider = null;
        public IConfigurationElement deploymentsProviderConfigElem = null;
        private IDeploymentsProvider deploymentsProvider = null;
        public IConfigurationElement launchConfigurationValidatorConfigElem = null;
        private ITestLaunchConfigurationValidator launchConfigurationValidator = null;

        private TestExtensionDescriptor() {
        }

        public IRunHandler getRunHandler() {
            block2: {
                if (this.runHandler != null || this.runHandlerConfigElem == null) break block2;
                try {
                    this.runHandler = (IRunHandler)this.runHandlerConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.runHandlerConfigElem = null;
                }
            }
            return this.runHandler;
        }

        public IExecutionHistoryDefaultsProvider getExecutionHistoryDefaultsProvider() {
            block2: {
                if (this.execHistoryDefaultsProvider != null || this.execHistoryDefaultsProviderConfigElem == null) break block2;
                try {
                    this.execHistoryDefaultsProvider = (IExecutionHistoryDefaultsProvider)this.execHistoryDefaultsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.execHistoryDefaultsProviderConfigElem = null;
                }
            }
            return this.execHistoryDefaultsProvider;
        }

        public IDeploymentsProvider getDeploymentsProvider() {
            block2: {
                if (this.deploymentsProvider != null || this.deploymentsProviderConfigElem == null) break block2;
                try {
                    this.deploymentsProvider = (IDeploymentsProvider)this.deploymentsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.deploymentsProviderConfigElem = null;
                }
            }
            return this.deploymentsProvider;
        }

        public ITestLaunchConfigurationValidator getLaunchConfigurationValidator() {
            block2: {
                if (this.launchConfigurationValidator != null || this.launchConfigurationValidatorConfigElem == null) break block2;
                try {
                    this.launchConfigurationValidator = (ITestLaunchConfigurationValidator)this.launchConfigurationValidatorConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.launchConfigurationValidatorConfigElem = null;
                }
            }
            return this.launchConfigurationValidator;
        }

        public boolean isLaunchConfigurationTypeSupported(String lcType) {
            return this.launchConfigurationType == lcType || lcType != null && lcType.equals(this.launchConfigurationType);
        }
    }
}

