/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class DeploymentProvider
extends LabelProvider
implements IStructuredContentProvider,
IElementComparer {
    private DeploymentsCache cache = null;

    public TPFDeployment[] getDeployments(Object testElement) {
        if (this.cache == null || !this.cache.getTestElement().equals(testElement)) {
            this.cache = new DeploymentsCache(testElement);
        }
        return this.cache.getDeployments();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof TPFTestSuite || inputElement instanceof TPFTestComponent) {
            return this.getDeployments(inputElement);
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        return TestUIImages.INSTANCE.getImage("deployment_obj.gif");
    }

    public String getText(Object element) {
        if (element instanceof TPFDeployment) {
            return ((TPFDeployment)element).getName();
        }
        return "<invalid deployment>";
    }

    public boolean equals(Object a, Object b) {
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof EObject && b instanceof EObject) {
            EObject ao = (EObject)a;
            EObject bo = (EObject)b;
            Resource ar = ao.eResource();
            Resource br = bo.eResource();
            return ar != null && br != null && ar.getURI().equals((Object)br.getURI()) && ar.getURIFragment(ao).equals(br.getURIFragment(bo));
        }
        return false;
    }

    public int hashCode(Object element) {
        return element.hashCode();
    }

    private class DeploymentsCache {
        private TPFDeployment[] deployments;
        private Object testElement;

        public DeploymentsCache(Object testElement) {
            if (testElement instanceof TPFTestSuite || testElement instanceof TPFTestComponent) {
                IDeploymentsProvider provider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(testElement);
                this.deployments = provider.getDeployments(testElement);
            }
            this.testElement = testElement;
        }

        public TPFDeployment[] getDeployments() {
            return this.deployments;
        }

        public Object getTestElement() {
            return this.testElement;
        }
    }
}

