/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class TestResourceChangeUpdater
implements IResourceChangeUpdater {
    private TestNavigator testNavigator;
    private List addedObjects;
    private List removedObjects;
    private List changedObjects;
    private List resourcesToSave;
    private Object[] expandedElements;
    private Object[] selectedElements;
    private boolean active;

    public TestResourceChangeUpdater(TestNavigator testNavigator) {
        this.testNavigator = testNavigator;
        this.active = true;
    }

    public void dispose() {
        this.testNavigator = null;
    }

    public void started() {
        this.addedObjects = new UniqueEList();
        this.removedObjects = new UniqueEList();
        this.changedObjects = new UniqueEList();
        this.resourcesToSave = new UniqueEList();
    }

    public void ended() {
        Iterator i;
        if (!this.addedObjects.isEmpty()) {
            i = this.addedObjects.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                Object parent = ((ITreeContentProvider)this.testNavigator.getViewer().getContentProvider()).getParent(object);
                if (parent == null) {
                    this.testNavigator.getTreeViewer().refresh(true);
                    return;
                }
                this.testNavigator.getTreeViewer().add(parent, object);
            }
        }
        if (!this.removedObjects.isEmpty()) {
            this.testNavigator.getTreeViewer().remove(this.removedObjects.toArray());
        }
        if (!this.changedObjects.isEmpty()) {
            i = this.changedObjects.iterator();
            while (i.hasNext()) {
                this.testNavigator.getTreeViewer().refresh(i.next(), true);
            }
        }
        if (!this.resourcesToSave.isEmpty()) {
            i = this.resourcesToSave.iterator();
            while (i.hasNext()) {
                try {
                    EMFUtil.save((Resource)i.next());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.addedObjects.clear();
        this.addedObjects = null;
        this.removedObjects.clear();
        this.removedObjects = null;
        this.changedObjects.clear();
        this.changedObjects = null;
        this.resourcesToSave.clear();
        this.resourcesToSave = null;
        if (this.expandedElements != null) {
            this.convertURIToEObject(this.expandedElements);
            this.testNavigator.getTreeViewer().setExpandedElements(this.expandedElements);
            this.convertURIToEObject(this.selectedElements);
            this.testNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.selectedElements), true);
            this.expandedElements = null;
            this.selectedElements = null;
        }
    }

    public boolean add(IResource parent, IResource[] affectedResources) {
        int i = 0;
        int maxi = affectedResources.length;
        while (i < maxi) {
            if (affectedResources[i].getType() != 1) {
                if (this.testNavigator.isVisibleResource(affectedResources[i])) {
                    this.addedObjects.add(affectedResources[i]);
                }
            } else {
                Object convertedObject = this.testNavigator.getConvertedObjectFromFile(affectedResources[i]);
                if (convertedObject == null) {
                    if (this.testNavigator.isVisibleResource(affectedResources[i])) {
                        this.addedObjects.add(affectedResources[i]);
                    }
                } else {
                    this.addedObjects.add(convertedObject);
                }
            }
            ++i;
        }
        return false;
    }

    public boolean remove(IResource parent, IResource[] affectedResources) {
        int i = 0;
        int maxi = affectedResources.length;
        while (i < maxi) {
            if (affectedResources[i].getType() != 1) {
                this.removedObjects.add(affectedResources[i]);
            } else {
                Object convertedObject = this.testNavigator.getCorrespondingObjectFromFile(affectedResources[i]);
                if (convertedObject == null) {
                    this.removedObjects.add(affectedResources[i]);
                } else {
                    this.removedObjects.add(convertedObject);
                    this.testNavigator.cleanConvertedObjectEntryFor(affectedResources[i]);
                    if (convertedObject instanceof EObject) {
                        Resource res = EMFUtil.getResource(null, (IFile)affectedResources[i]);
                        EMFUtil.remove(res);
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean replaced(IResource affectedResource) {
        return false;
    }

    public boolean updateProperties(IResource affectedResource) {
        if (affectedResource.getType() == 1) {
            Object[] eObjects = EMFUtil.getEObjects(null, (IFile)affectedResource);
            if (eObjects.length > 0) {
                this.testNavigator.getTreeViewer().update(eObjects, null);
            }
        } else {
            this.testNavigator.getTreeViewer().update((Object)affectedResource, null);
        }
        return false;
    }

    public boolean updateChildrenType(IResource affectedResource) {
        return false;
    }

    public boolean updateContent(IResource parent, IResource affectedResource) {
        URI uri = this.getFileURI(affectedResource);
        if (uri != null) {
            EMFUtil.unloadIfNeeded(uri);
            Object convertedObject = this.testNavigator.getCorrespondingObjectFromFile(affectedResource);
            if (convertedObject != null) {
                this.removedObjects.add(convertedObject);
                this.testNavigator.cleanConvertedObjectEntryFor(affectedResource);
                convertedObject = this.testNavigator.getConvertedObjectFromFile(affectedResource);
                this.addedObjects.add(convertedObject);
            } else {
                this.changedObjects.add(affectedResource);
            }
            if (this.expandedElements == null) {
                this.expandedElements = this.testNavigator.getTreeViewer().getExpandedElements();
                this.convertEObjectToURI(this.expandedElements);
                this.selectedElements = ((IStructuredSelection)this.testNavigator.getTreeViewer().getSelection()).toArray();
                this.convertEObjectToURI(this.selectedElements);
            }
        }
        return false;
    }

    public void setActive(boolean enable) {
        this.active = enable;
    }

    public boolean isActive() {
        return this.active;
    }

    protected URI getFileURI(IResource resource) {
        if (resource.getType() == 1) {
            String fileExtension = resource.getFileExtension();
            String[] files = this.testNavigator.getVisibleFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].equals(fileExtension)) {
                    return URI.createPlatformResourceURI((String)resource.getFullPath().toString());
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean isValid(EObject eObject) {
        return eObject instanceof CMNNamedElement;
    }

    private void convertEObjectToURI(Object[] objects) {
        int i = 0;
        int maxi = objects.length;
        while (i < maxi) {
            if (objects[i] instanceof EObject) {
                objects[i] = EcoreUtil.getURI((EObject)((EObject)objects[i]));
            }
            ++i;
        }
    }

    private void convertURIToEObject(Object[] objects) {
        int i = 0;
        int maxi = objects.length;
        while (i < maxi) {
            if (objects[i] instanceof URI) {
                objects[i] = EMFUtil.getResourceSet().getEObject((URI)objects[i], false);
            }
            ++i;
        }
    }
}

