/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ReportGeneratorPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private ReportManager reportManager;
    private TableViewer tableViewer;
    private ArrayList tableElements = new ArrayList();
    private Button btnAdd;
    private Button btnRemove;
    private Button btnRename;
    private Button btnTest;

    public ReportGeneratorPage() {
        this.setPreferenceStore(TestUIPlugin.getInstance().getPreferenceStore());
        this.reportManager = TestUI.getReportManager();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        composite.setLayout((Layout)new GridLayout());
        this.createTable(composite);
        WorkbenchHelp.setHelp((Control)parent, (String)(TestUIPlugin.getID() + ".rgpp0001"));
        return composite;
    }

    private Control createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.createTableViewer(composite);
        Composite buttons = new Composite(composite, 0);
        data = new GridData(1040);
        data.widthHint = 90;
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons);
        this.initializeValues();
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnTest.addSelectionListener((SelectionListener)this);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridDataUtil.createFill();
        data.heightHint = 50;
        data.widthHint = 100;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(TestUIPlugin.getString("REP_COL_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn certificateColumn = new TableColumn(table, 16384);
        certificateColumn.setText(TestUIPlugin.getString("REP_COL_FILE"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof ReportDescription && !((ReportDescription)element).isDefinedByPlugin();
            }
        });
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this.tableViewer.getTable(), (String)(TestUIPlugin.getID() + ".rgpp0013"));
    }

    private void createButtons(Composite parent) {
        this.btnAdd = new Button(parent, 8);
        this.btnAdd.setText(TestUIPlugin.getString("label.Add"));
        GridData data = GridDataUtil.createHorizontalFill();
        data.widthHint = 20;
        this.btnAdd.setLayoutData((Object)data);
        this.btnRemove = new Button(parent, 8);
        this.btnRemove.setText(TestUIPlugin.getString("label.Remove"));
        data = GridDataUtil.createHorizontalFill();
        data.widthHint = 20;
        this.btnRemove.setLayoutData((Object)data);
        this.btnRemove.setEnabled(false);
        Composite space = new Composite(parent, 0);
        data = GridDataUtil.createHorizontalFill();
        data.verticalSpan = 2;
        space.setLayoutData((Object)data);
        this.btnRename = new Button(parent, 8);
        this.btnRename.setText(TestUIPlugin.getString("label.Update"));
        data = GridDataUtil.createHorizontalFill();
        data.widthHint = 20;
        this.btnRename.setLayoutData((Object)data);
        this.btnRename.setEnabled(false);
        this.btnTest = new Button(parent, 8);
        this.btnTest.setText(TestUIPlugin.getString("label.Test"));
        data = GridDataUtil.createHorizontalFill();
        data.widthHint = 20;
        this.btnTest.setLayoutData((Object)data);
        this.btnTest.setEnabled(false);
        WorkbenchHelp.setHelp((Control)this.btnAdd, (String)(TestUIPlugin.getID() + ".rgpp0002"));
        WorkbenchHelp.setHelp((Control)this.btnRemove, (String)(TestUIPlugin.getID() + ".rgpp0003"));
        WorkbenchHelp.setHelp((Control)this.btnRename, (String)(TestUIPlugin.getID() + ".rgpp0004"));
        WorkbenchHelp.setHelp((Control)this.btnTest, (String)(TestUIPlugin.getID() + ".rgpp0005"));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        StructuredSelection selection;
        ReportDescription reportDescription;
        block15: {
            Iterator i;
            IStructuredSelection elem;
            block17: {
                Object obj;
                block16: {
                    block14: {
                        if (event.widget != this.btnAdd) break block14;
                        ReportDialog dlg = new ReportDialog(this.getShell(), null);
                        dlg.open();
                        if (dlg.getReturnCode() == 0) {
                            ReportDescription rptDesc = dlg.getReportDefinition();
                            this.reportManager.addReportDefinition((IReportDescription)rptDesc);
                            this.tableElements.add(rptDesc);
                            this.tableViewer.refresh();
                            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)rptDesc));
                        }
                        break block15;
                    }
                    if (event.widget != this.btnRemove) break block16;
                    elem = (IStructuredSelection)this.tableViewer.getSelection();
                    if (elem.size() > 0) {
                        i = elem.iterator();
                        while (i.hasNext()) {
                            IReportDescription rptDesc = (IReportDescription)i.next();
                            this.reportManager.removeReportDefinition(rptDesc);
                            this.tableElements.remove(rptDesc);
                        }
                        this.tableViewer.refresh();
                    }
                    break block15;
                }
                if (event.widget != this.btnRename) break block17;
                elem = (IStructuredSelection)this.tableViewer.getSelection();
                if (elem.size() <= 0 || !((obj = elem.getFirstElement()) instanceof ReportDescription)) break block15;
                ReportDialog dlg = new ReportDialog(this.getShell(), (ReportDescription)obj);
                dlg.open();
                if (dlg.getReturnCode() != 0) break block15;
                this.tableViewer.refresh();
                break block15;
            }
            if (event.widget == this.btnTest && (elem = (IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
                i = elem.iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (!(obj instanceof ReportDescription)) continue;
                    ReportDescription reportDescription2 = (ReportDescription)obj;
                    try {
                        String message;
                        String className;
                        if (reportDescription2.getReportGenerator() != null) {
                            className = "";
                            if (reportDescription2.getClassName() != null) {
                                className = reportDescription2.getClassName();
                            }
                            message = TestUIPlugin.getString("preferences.report.TestButton.Succeed", className);
                            MessageDialog.openInformation((Shell)this.getShell(), (String)TestUIPlugin.getString("W_SUCCESS"), (String)message);
                            continue;
                        }
                        className = "";
                        if (reportDescription2.getClassName() != null) {
                            className = reportDescription2.getClassName();
                        }
                        message = TestUIPlugin.getString("_ERROR_preferences.report.TestButton.Fail.CantFind", className);
                        MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)message);
                    }
                    catch (ClassCastException e) {
                        String className = "";
                        if (reportDescription2.getClassName() != null) {
                            className = reportDescription2.getClassName();
                        }
                        String message = TestUIPlugin.getString("_ERROR_preferences.report.TestButton.Fail.Instance", className);
                        MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)message);
                    }
                    catch (Exception e) {
                        String className = "";
                        if (reportDescription2.getClassName() != null) {
                            className = reportDescription2.getClassName();
                        }
                        String message = TestUIPlugin.getString("_ERROR_preferences.report.TestButton.Fail.CantFind", className);
                        MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)message);
                    }
                }
            }
        }
        ISelection sel = this.tableViewer.getSelection();
        this.btnRename.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnTest.setEnabled(false);
        if (sel != null && sel instanceof StructuredSelection && (reportDescription = (ReportDescription)(selection = (StructuredSelection)sel).getFirstElement()) != null) {
            boolean isDefinedByPlugin = reportDescription.isDefinedByPlugin();
            this.btnRename.setEnabled(!isDefinedByPlugin);
            this.btnRemove.setEnabled(!isDefinedByPlugin);
            this.btnTest.setEnabled(true);
        }
    }

    protected void openErrorMessageBox(String message) {
    }

    public Point computeSize() {
        Point p = super.computeSize();
        return p;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.reportManager.saveIntoPreferenceStore();
        return true;
    }

    private void initializeValues() {
        IReportDescription[] list = this.reportManager.getReportDescriptions();
        int idx = 0;
        while (idx < list.length) {
            this.tableElements.add(list[idx]);
            ++idx;
        }
        this.tableViewer.setInput((Object)this.tableElements);
    }

    public class ReportDialog
    extends Dialog
    implements Listener {
        private ReportDescription report;
        private ReportGeneratorUI reportGeneratorUI;

        public ReportDialog(Shell shell, ReportDescription report) {
            super(shell);
            this.report = report;
        }

        protected Control createDialogArea(Composite parent) {
            if (this.report == null) {
                this.getShell().setText(TestUIPlugin.getString("ADD_REPORT_DESC_DLG"));
            } else {
                this.getShell().setText(TestUIPlugin.getString("EDIT_REPORT_DESC_DLG"));
            }
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)GridDataUtil.createFill());
            result.setLayout((Layout)new GridLayout());
            this.reportGeneratorUI = new ReportGeneratorUI(this.getShell());
            Composite content = this.reportGeneratorUI.createControl(result);
            if (this.report != null) {
                this.reportGeneratorUI.setName(this.report.getName());
                this.reportGeneratorUI.setClassname(this.report.getClassName());
                this.reportGeneratorUI.setClasspath(this.report.getClassPath());
            }
            WorkbenchHelp.setHelp((Control)content, (String)(TestUIPlugin.getID() + ".rgpp0007"));
            return content;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.reportGeneratorUI.registerListener(this);
            if (this.report == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.report == null) {
                this.report = new ReportDescription(((Object)((Object)this)).getClass().getClassLoader(), this.reportGeneratorUI.getName(), this.reportGeneratorUI.getClassName(), this.reportGeneratorUI.getClassPath());
            } else {
                this.report.setName(this.reportGeneratorUI.getName());
                this.report.setClassName(this.reportGeneratorUI.getClassName());
                this.report.setClassPath(this.reportGeneratorUI.getClassPath());
            }
            super.okPressed();
        }

        public ReportDescription getReportDefinition() {
            return this.report;
        }

        public void handleEvent(Event e) {
            this.getButton(0).setEnabled(!this.reportGeneratorUI.getName().equals("") && !this.reportGeneratorUI.getClassName().equals(""));
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return TestUIImages.INSTANCE.getImage("report_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ReportDescription) {
                ReportDescription myTableElement = (ReportDescription)element;
                if (columnIndex == 0) {
                    return myTableElement.getName();
                }
                if (columnIndex == 1) {
                    return myTableElement.getClassName();
                }
            }
            return "";
        }
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ArrayList) {
                return ((ArrayList)element).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ReportGeneratorUI
    implements SelectionListener,
    ModifyListener {
        private Text _classname;
        private Text _name;
        private Text _classpath;
        private Button _browseClass;
        private Button _browseDirPath;
        private Button _browseJarPath;
        private Shell shell;
        private Listener _listener;

        public ReportGeneratorUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createArgumentsControl(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            label.setText(TestUIPlugin.getString("CLASSPATH"));
            label.setLayoutData((Object)gd);
            this._classpath = new Text(parent, 2882);
            gd = GridDataUtil.createFill();
            gd.heightHint = 100;
            gd.widthHint = 250;
            this._classpath.setLayoutData((Object)gd);
            Composite btnGroup = new Composite(parent, 0);
            gd = GridDataUtil.createVerticalFill();
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            btnGroup.setLayoutData((Object)gd);
            btnGroup.setLayout((Layout)layout);
            this._browseDirPath = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            this._browseDirPath.setLayoutData((Object)gd);
            this._browseDirPath.setText(TestUIPlugin.getString("ADD_DIRECTORY"));
            this._browseJarPath = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this._browseJarPath.setLayoutData((Object)gd);
            this._browseJarPath.setText(TestUIPlugin.getString("ADD_JAR"));
            this._browseDirPath.addSelectionListener((SelectionListener)this);
            this._browseJarPath.addSelectionListener((SelectionListener)this);
            this._classname.addModifyListener((ModifyListener)this);
            WorkbenchHelp.setHelp((Control)this._classpath, (String)(TestUIPlugin.getID() + ".lpui0001"));
            return parent;
        }

        public Composite createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 5;
            content.setLayout((Layout)layout);
            GridData gd = GridDataUtil.createFill();
            gd.horizontalIndent = 5;
            content.setLayoutData((Object)gd);
            Label label = new Label(content, 0);
            label.setText(TestUIPlugin.getString("label.Name"));
            this._name = new Text(content, 2052);
            gd = GridDataUtil.createHorizontalFill();
            gd.horizontalSpan = 2;
            this._name.setLayoutData((Object)gd);
            label = new Label(content, 0);
            label.setText(TestUIPlugin.getString("preference.report.Classfile"));
            this._classname = new Text(content, 2052);
            this._classname.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            Composite btnGroup = new Composite(content, 0);
            gd = GridDataUtil.createVerticalFill();
            layout = new GridLayout();
            layout.numColumns = 1;
            btnGroup.setLayoutData((Object)gd);
            btnGroup.setLayout((Layout)layout);
            this._browseClass = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this._browseClass.setLayoutData((Object)gd);
            this._browseClass.setText(TestUIPlugin.getString("BROWSE"));
            this._browseClass.addSelectionListener((SelectionListener)this);
            this._name.setFocus();
            this._name.addModifyListener((ModifyListener)this);
            this.createArgumentsControl(content);
            WorkbenchHelp.setHelp((Control)this._classname, (String)(TestUIPlugin.getID() + ".rgpp0011"));
            WorkbenchHelp.setHelp((Control)this._classpath, (String)(TestUIPlugin.getID() + ".rgpp0010"));
            WorkbenchHelp.setHelp((Control)this._name, (String)(TestUIPlugin.getID() + ".rgpp0012"));
            WorkbenchHelp.setHelp((Control)this._browseClass, (String)(TestUIPlugin.getID() + ".rgpp0006"));
            WorkbenchHelp.setHelp((Control)this._browseDirPath, (String)(TestUIPlugin.getID() + ".rgpp0008"));
            WorkbenchHelp.setHelp((Control)this._browseJarPath, (String)(TestUIPlugin.getID() + ".rgpp0009"));
            return content;
        }

        public void enable(boolean enableClassName, boolean enableArgs, boolean enableBrowseClass, boolean enableBrowseArgs, boolean enableEnv) {
            this._classname.setEnabled(enableClassName);
            this._browseClass.setEnabled(enableBrowseClass);
            this._classpath.setEnabled(enableArgs);
            this._name.setEnabled(enableArgs);
            this._browseDirPath.setEnabled(enableBrowseArgs);
            this._browseJarPath.setEnabled(enableBrowseArgs);
            if (enableClassName) {
                this._classname.setFocus();
                this._classname.selectAll();
            }
        }

        public String getClassName() {
            return this._classname.getText().trim();
        }

        public String getClassPath() {
            return this._classpath.getText().trim();
        }

        public Text getClassUI() {
            return this._classname;
        }

        public Control getBrowseJarButton() {
            return this._browseJarPath;
        }

        public Control getBrowseDirButton() {
            return this._browseDirPath;
        }

        public String getName() {
            return this._name.getText().trim();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent e) {
            String osName = System.getProperty("os.name");
            if (e.widget == this._browseClass) {
                FileDialog dlg = new FileDialog(this.shell);
                dlg.setFilterExtensions(new String[]{"*.class"});
                dlg.open();
                String fileName = dlg.getFileName();
                if (fileName != null && !fileName.equals("")) {
                    String oldClassPath;
                    if (fileName.endsWith(".class")) {
                        fileName = fileName.substring(0, fileName.length() - 6);
                    }
                    this._classname.setText(fileName);
                    String classpath = dlg.getFilterPath();
                    if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                        classpath = classpath + "\\";
                    }
                    oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                    this._classpath.setText(oldClassPath + classpath);
                }
            } else if (e.widget == this._browseDirPath) {
                DirectoryDialog dlg = new DirectoryDialog(this.shell);
                String classpath = dlg.open();
                if (classpath != null && !classpath.equals("")) {
                    String oldClassPath;
                    if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                        classpath = classpath + "\\";
                    }
                    oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                    classpath = oldClassPath + classpath;
                    this._classpath.setText(classpath);
                    this._classpath.setFocus();
                }
            } else if (e.widget == this._browseJarPath) {
                FileDialog dlg = new FileDialog(this.shell);
                dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
                dlg.open();
                String classpath = dlg.getFileName();
                if (classpath != null && !classpath.equals("")) {
                    classpath = dlg.getFilterPath() + File.separator + classpath;
                    String oldClassPath = this._classpath.getText().trim();
                    oldClassPath = oldClassPath.equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                    classpath = oldClassPath + classpath;
                    this._classpath.setText(classpath);
                }
            }
        }

        public void modifyText(ModifyEvent e) {
            this.notifyListener();
        }

        public void setClassname(String text) {
            this._classname.setText(text);
        }

        public void setClasspath(String text) {
            if (text != null) {
                this._classpath.setText(text);
            }
        }

        public void setName(String text) {
            this._name.setText(text);
        }

        public void registerListener(Listener listener) {
            this._listener = listener;
        }

        public void notifyListener() {
            if (this._listener != null) {
                this._listener.handleEvent(null);
            }
        }
    }
}

