/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.wizard.ArtifactSelectionPage;
import org.eclipse.hyades.test.ui.util.ArtifactUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class ArtifactNewWizard
extends HyadesNewWizard {
    private ArtifactSelectionPage artifactSelectionPage = null;
    private CFGArtifact newArtifact;

    public ArtifactNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_ARTIFACT_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newartifact_wiz.gif"));
        IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("AritfactNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("ArtifactNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected String getType() {
        return "org.eclipse.hyades.artifact.generic";
    }

    public String getFileExtension() {
        return "artifact";
    }

    protected void initPages() {
        super.initPages();
        this.artifactSelectionPage = new ArtifactSelectionPage("assetSelection");
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        this.artifactSelectionPage.setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_ASS_PG_TTL"));
        this.artifactSelectionPage.setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_ASS_PG_DSC"));
        this.addPage((IWizardPage)this.artifactSelectionPage);
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        EObject[] eObjects;
        this.newArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
        this.newArtifact.setName(this.getAttributeWizardPage().getItemName());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            this.newArtifact.setDescription(description);
        }
        if ((eObjects = this.artifactSelectionPage.getCheckedObjects()) != null && eObjects.length > 0) {
            int i = 0;
            while (i < eObjects.length) {
                if (eObjects[i] instanceof CFGClass) {
                    ArtifactUtil.associateTestAsset((CFGClass)eObjects[i], this.newArtifact);
                }
                ++i;
            }
        }
        return this.newArtifact;
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("artifact");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.ArtifactEditorPart", (boolean)false);
        }
    }

    public CFGArtifact getNewArtifact() {
        return this.newArtifact;
    }
}

