/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatapoolCSVImportPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private static final String WIZ_DATAPOOL_CSV_PG_ENC = "Import Encoding:";
    private Button browseButton = null;
    private Button firstRowVarButton = null;
    private Button firstColEqClsButton = null;
    private Text csvFileText = null;
    private Combo encodingCombo = null;
    private String importEncoding = new String();

    protected DatapoolCSVImportPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        mainComposite.setLayout((Layout)layout);
        Label label = new Label(mainComposite, 0);
        label.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_SEL"));
        Composite fileComposite = new Composite(mainComposite, 0);
        GridLayout fileLayout = new GridLayout();
        fileLayout = new GridLayout();
        fileLayout.numColumns = 2;
        fileLayout.marginHeight = 0;
        fileLayout.marginWidth = 0;
        fileLayout.makeColumnsEqualWidth = false;
        fileComposite.setLayout((Layout)fileLayout);
        GridData gridData = GridDataUtil.createHorizontalFill();
        fileComposite.setLayoutData((Object)gridData);
        this.csvFileText = new Text(fileComposite, 2048);
        gridData = GridDataUtil.createHorizontalFill();
        gridData.widthHint = 300;
        this.csvFileText.setLayoutData((Object)gridData);
        this.csvFileText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(fileComposite, 8);
        this.browseButton.setText(TestUIPlugin.getString("BROWSE"));
        this.browseButton.addSelectionListener((SelectionListener)this);
        Composite encodingComposite = new Composite(mainComposite, 0);
        GridLayout encodingLayout = new GridLayout();
        encodingLayout = new GridLayout();
        encodingLayout.numColumns = 2;
        encodingLayout.marginHeight = 0;
        encodingLayout.marginWidth = 0;
        encodingLayout.makeColumnsEqualWidth = false;
        encodingComposite.setLayout((Layout)encodingLayout);
        gridData = GridDataUtil.createHorizontalFill();
        encodingComposite.setLayoutData((Object)gridData);
        Label encodingLabel = new Label(encodingComposite, 0);
        encodingLabel.setText(WIZ_DATAPOOL_CSV_PG_ENC);
        String[] encodings = new String[]{"Default System Encoding", "ASCII", "ISO Latin Alphabet", "Unicode Eight-bit", "Unicode Byte-Order", "Unicode Little-Endian", "Unicode Big-Endian"};
        String[] encodingValues = new String[]{new String(), "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16", "UTF-16LE", "UTF-16BE"};
        this.encodingCombo = new Combo(encodingComposite, 12);
        this.encodingCombo.setItems(encodings);
        this.encodingCombo.setData((Object)encodingValues);
        this.encodingCombo.select(0);
        this.encodingCombo.addSelectionListener((SelectionListener)new EncodingSelectionAdapter());
        Composite optionComposite = new Composite(mainComposite, 0);
        GridLayout optionLayout = new GridLayout();
        optionLayout = new GridLayout();
        optionLayout.numColumns = 2;
        optionLayout.marginHeight = 0;
        optionLayout.marginWidth = 0;
        optionLayout.makeColumnsEqualWidth = false;
        optionComposite.setLayout((Layout)optionLayout);
        gridData = GridDataUtil.createHorizontalFill();
        optionComposite.setLayoutData((Object)gridData);
        this.firstRowVarButton = new Button(optionComposite, 32);
        this.firstRowVarButton.setSelection(true);
        Label firstRowLabel = new Label(optionComposite, 0);
        firstRowLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_COL_HEADER"));
        this.firstColEqClsButton = new Button(optionComposite, 32);
        this.firstColEqClsButton.setSelection(true);
        Label firstColLabel = new Label(optionComposite, 0);
        firstColLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_ROW_HEADER"));
        this.setControl((Control)mainComposite);
    }

    private String getCSVFileNameFromDialog() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        dialog.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_SEL"));
        if (this.csvFileText.getText().trim().length() > 0) {
            dialog.setFilterPath(this.csvFileText.getText());
        }
        String res = dialog.open();
        return res;
    }

    public String getCSVFileName() {
        return this.csvFileText.getText();
    }

    public boolean firstRowContainsVariableNameType() {
        return this.firstRowVarButton.getSelection();
    }

    public boolean firstColumnContainsEquivalenceClassName() {
        return this.firstColEqClsButton.getSelection();
    }

    public String getImportEncoding() {
        return this.importEncoding;
    }

    public void modifyText(ModifyEvent e) {
        if (this.csvFileText.getText().trim().length() > 0) {
            this.setPageComplete(true);
            this.getContainer().updateButtons();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        String tempCSVFileName = this.getCSVFileNameFromDialog();
        if (tempCSVFileName != null) {
            this.csvFileText.setText(tempCSVFileName);
            this.setPageComplete(true);
            this.getContainer().updateButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    class EncodingSelectionAdapter
    implements SelectionListener {
        EncodingSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Combo) {
                Combo combo = (Combo)e.widget;
                int index = combo.getSelectionIndex();
                DatapoolCSVImportPage.this.importEncoding = ((String[])combo.getData())[index];
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

