/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class BaseString {
    private static final String ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String NUMERIC = "0123456789";

    public static String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Object[]) {
            return BaseString.arrayToString((Object[])o);
        }
        if (o instanceof List) {
            return BaseString.arrayToString(((List)o).toArray());
        }
        if (o instanceof Collection) {
            return BaseString.arrayToString(((Collection)o).toArray());
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public static String arrayToString(Object[] array) {
        return BaseString.arrayToString(array, " ");
    }

    public static String arrayToString(Object[] array, String separator) {
        if (array == null) {
            return "";
        }
        separator = BaseString.toString(separator);
        String ret = "";
        int max = array.length;
        if (max > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < max) {
                sb.append(separator).append(array[i].toString());
                ++i;
            }
            ret = sb.toString().substring(separator.length());
        }
        return ret;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        PrintStream errorPS = new PrintStream(errorStream);
        throwable.printStackTrace(errorPS);
        errorPS.flush();
        String stackTrace = errorStream.toString();
        try {
            errorStream.close();
        }
        catch (Exception e) {}
        return stackTrace;
    }

    public static byte[] encode(String encoding, String text) {
        if (text != null) {
            if (encoding == null) {
                return text.getBytes();
            }
            try {
                return text.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
            }
        }
        return null;
    }

    public static String[] tokenizer(String text, String token, boolean includeToken) {
        if (text == null || token == null) {
            return null;
        }
        Vector<String> ret = new Vector<String>();
        int index = 0;
        do {
            if ((index = text.indexOf(token)) < 0) continue;
            if (index > 0) {
                ret.add(text.substring(0, index));
            }
            text = text.substring(index += token.length());
            if (!includeToken) continue;
            ret.add(token);
        } while (index >= 0);
        if (text.length() > 0) {
            ret.add(text);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static int occurrenceOf(String srcString, char searchChar) {
        int result = 0;
        if (srcString.length() > 0) {
            int i = 0;
            while (i < srcString.length()) {
                if (searchChar == srcString.charAt(i)) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public static String replace(String in, String oldString, String newString) {
        if (in == null || oldString == null || newString == null) {
            return in;
        }
        if (oldString.length() == 0) {
            return in;
        }
        if (oldString.length() == 1 && newString.length() == 1) {
            return in.replace(oldString.charAt(0), newString.charAt(0));
        }
        int lastIndex = 0;
        int newIndex = 0;
        StringBuffer sb = new StringBuffer();
        while ((newIndex = in.indexOf(oldString, lastIndex)) != -1) {
            sb.append(in.substring(lastIndex, newIndex)).append(newString);
            lastIndex = newIndex + oldString.length();
        }
        sb.append(in.substring(lastIndex));
        return sb.toString();
    }

    public static String toProperCase(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        if (text.length() == 1) {
            return text.toUpperCase();
        }
        StringBuffer sb = new StringBuffer();
        String[] pieces = BaseString.tokenizer(text, " ", true);
        int i = 0;
        while (i < pieces.length) {
            sb.append(pieces[i].substring(0, 1).toUpperCase());
            if (pieces[i].length() > 1) {
                sb.append(pieces[i].substring(1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isAlphanumeric(String srcString) {
        return BaseString.lastIndexOfAnyBut(srcString, ALPHANUMERIC) == -1;
    }

    public static int lastIndexOfAnyBut(String srcString, String validString) {
        int result = -1;
        int srcLen = srcString.length();
        int i = srcLen - 1;
        while (i >= 0) {
            if (validString.indexOf(srcString.charAt(i)) == -1) {
                result = i;
                break;
            }
            --i;
        }
        return result;
    }

    public static boolean isDigits(String srcString) {
        return BaseString.lastIndexOfAnyBut(srcString, NUMERIC) == -1;
    }
}

