/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.exceptions.InvalidExtendedDataElementTypeException;

public class ExtendedDataElementImpl
implements IExtendedDataElement,
Serializable,
Cloneable {
    static final long serialVersionUID = 6633427043459375461L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = ExtendedDataElementImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("type", Integer.TYPE), new ObjectStreamField("values", class$java$lang$Object == null ? (class$java$lang$Object = ExtendedDataElementImpl.class$("java.lang.Object")) : class$java$lang$Object), new ObjectStreamField("valuesType", Integer.TYPE), new ObjectStreamField("children", array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement = ExtendedDataElementImpl.class$("[Lorg.eclipse.hyades.logging.events.IExtendedDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement)};
    private String name = null;
    private int type = -1;
    private Object values = null;
    private int valuesType = -1;
    private ArrayList children = null;
    private String id = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement;

    protected ExtendedDataElementImpl() {
    }

    public void addChildDataElement(IExtendedDataElement iExtendedDataElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(iExtendedDataElement);
    }

    public IExtendedDataElement getChildDataElement(String string) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.size()) {
                if (((IExtendedDataElement)this.children.get(n)).getName().equals(string)) {
                    return (IExtendedDataElement)this.children.get(n);
                }
                ++n;
            }
        }
        return null;
    }

    public List getChildDataElements() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public void removeChildDataElement(String string) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.size()) {
                if (((IExtendedDataElement)this.children.get(n)).getName().equals(string)) {
                    this.children.remove(n--);
                }
                ++n;
            }
        }
    }

    public void clearChildDataElements() {
        this.children = null;
    }

    public List getValues() {
        if (this.values != null) {
            return Arrays.asList(this.getValuesAsStringArray());
        }
        return null;
    }

    public String[] getValuesAsStringArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 15: {
                    return (String[])this.values;
                }
                case 9: {
                    byte[] byArray = (byte[])this.values;
                    String[] stringArray = new String[byArray.length];
                    int n = 0;
                    while (n < byArray.length) {
                        stringArray[n] = String.valueOf(byArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 10: {
                    short[] sArray = (short[])this.values;
                    String[] stringArray = new String[sArray.length];
                    int n = 0;
                    while (n < sArray.length) {
                        stringArray[n] = String.valueOf(sArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 11: {
                    int[] nArray = (int[])this.values;
                    String[] stringArray = new String[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        stringArray[n] = String.valueOf(nArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 12: {
                    long[] lArray = (long[])this.values;
                    String[] stringArray = new String[lArray.length];
                    int n = 0;
                    while (n < lArray.length) {
                        stringArray[n] = String.valueOf(lArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 13: {
                    float[] fArray = (float[])this.values;
                    String[] stringArray = new String[fArray.length];
                    int n = 0;
                    while (n < fArray.length) {
                        stringArray[n] = String.valueOf(fArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 14: {
                    double[] dArray = (double[])this.values;
                    String[] stringArray = new String[dArray.length];
                    int n = 0;
                    while (n < dArray.length) {
                        stringArray[n] = String.valueOf(dArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 16: {
                    boolean[] blArray = (boolean[])this.values;
                    String[] stringArray = new String[blArray.length];
                    int n = 0;
                    while (n < blArray.length) {
                        stringArray[n] = String.valueOf(blArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
                case 18: {
                    char[] cArray = (char[])this.values;
                    String[] stringArray = new String[cArray.length];
                    int n = 0;
                    while (n < cArray.length) {
                        stringArray[n] = String.valueOf(cArray[n]);
                        ++n;
                    }
                    return stringArray;
                }
            }
            return new String[]{this.values.toString()};
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeValue() {
        return this.type;
    }

    public String getType() {
        switch (this.type) {
            case 0: {
                return "byte";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "long";
            }
            case 7: {
                return "boolean";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "string";
            }
            case 8: {
                return "dateTime";
            }
            case 9: {
                return "byteArray";
            }
            case 10: {
                return "shortArray";
            }
            case 11: {
                return "intArray";
            }
            case 12: {
                return "longArray";
            }
            case 16: {
                return "booleanArray";
            }
            case 13: {
                return "floatArray";
            }
            case 14: {
                return "doubleArray";
            }
            case 15: {
                return "stringArray";
            }
            case 17: {
                return "dateTimeArray";
            }
            case 18: {
                return "hexBinary";
            }
            case 19: {
                return "noValue";
            }
        }
        return null;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int n) {
        if (n < 0 || n > 19) {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + this.getType());
        }
        this.type = n;
    }

    public void setType(String string) {
        if (string.equals("byte")) {
            this.type = 0;
        } else if (string.equals("boolean")) {
            this.type = 7;
        } else if (string.equals("short")) {
            this.type = 1;
        } else if (string.equals("int")) {
            this.type = 2;
        } else if (string.equals("long")) {
            this.type = 3;
        } else if (string.equals("float")) {
            this.type = 4;
        } else if (string.equals("double")) {
            this.type = 5;
        } else if (string.equals("dateTime")) {
            this.type = 8;
        } else if (string.equals("string")) {
            this.type = 6;
        } else if (string.equals("byteArray")) {
            this.type = 9;
        } else if (string.equals("booleanArray")) {
            this.type = 16;
        } else if (string.equals("shortArray")) {
            this.type = 10;
        } else if (string.equals("intArray")) {
            this.type = 11;
        } else if (string.equals("longArray")) {
            this.type = 12;
        } else if (string.equals("floatArray")) {
            this.type = 13;
        } else if (string.equals("doubleArray")) {
            this.type = 14;
        } else if (string.equals("dateTimeArray")) {
            this.type = 17;
        } else if (string.equals("stringArray")) {
            this.type = 15;
        } else if (string.equals("hexBinary")) {
            this.type = 18;
        } else if (string.equals("noValue")) {
            this.type = 19;
        } else {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + this.getType());
        }
    }

    public void setValues(String[] stringArray) {
        this.values = stringArray;
    }

    public void setHexValues(char[] cArray) {
        this.values = cArray;
        this.type = 18;
        this.valuesType = 18;
    }

    public void setHexValue(byte[] byArray) {
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                cArray[n] = (char)(byArray[n] + 128);
                ++n;
            }
        }
        this.setHexValues(cArray);
    }

    public String getString() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 6: {
                    return (String)this.values;
                }
                case 15: {
                    return ((String[])this.values)[0];
                }
            }
            throw new InvalidExtendedDataElementTypeException("getString was called for an illegal event property type");
        }
        return null;
    }

    public boolean getBoolean() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 7: {
                    return (Boolean)this.values;
                }
                case 15: {
                    return new Boolean(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getBoolean was called for an illegal event property type");
        }
        return true;
    }

    public byte getByte() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 0: {
                    return (Byte)this.values;
                }
                case 15: {
                    return new Byte(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getByte was called for an illegal event property type");
        }
        return 0;
    }

    public short getShort() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 1: {
                    return (Short)this.values;
                }
                case 15: {
                    return new Short(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getShort was called for an illegal event property type");
        }
        return 0;
    }

    public int getInt() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 2: {
                    return (Integer)this.values;
                }
                case 15: {
                    return new Integer(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getInt was called for an illegal event property type");
        }
        return 0;
    }

    public long getLong() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 3: {
                    return (Long)this.values;
                }
                case 15: {
                    return new Long(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getLong was called for an illegal event property type");
        }
        return 0L;
    }

    public float getFloat() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 4: {
                    return ((Float)this.values).floatValue();
                }
                case 15: {
                    return new Float(((String[])this.values)[0]).floatValue();
                }
            }
            throw new InvalidExtendedDataElementTypeException("getFloat was called for an illegal event property type");
        }
        return 0.0f;
    }

    public double getDouble() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 5: {
                    return (Double)this.values;
                }
                case 15: {
                    return new Double(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getDouble was called for an illegal event property type");
        }
        return 0.0;
    }

    public String[] getStringArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 15: {
                    return (String[])this.values;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getStringArray was called for an illegal event property type");
        }
        return null;
    }

    public long getDateTimeAsLong() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 6: {
                    return CbeFormatter.convertXmlSchemaDateTimeToDate((String)this.values);
                }
                case 15: {
                    return CbeFormatter.convertXmlSchemaDateTimeToDate(((String[])this.values)[0]);
                }
            }
            throw new InvalidExtendedDataElementTypeException("getDateTimeAsLong was called for an illegal event property type");
        }
        return 0L;
    }

    public String getDateTime() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 6: {
                    return (String)this.values;
                }
                case 15: {
                    return ((String[])this.values)[0];
                }
            }
            throw new InvalidExtendedDataElementTypeException("getDateTime was called for an illegal event property type");
        }
        return null;
    }

    public long[] getDateTimeArrayAsLong() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 15: {
                    String[] stringArray = (String[])this.values;
                    long[] lArray = new long[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        lArray[n] = CbeFormatter.convertXmlSchemaDateTimeToDate(stringArray[n]);
                        ++n;
                    }
                    return lArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getDateTimeArrayAsLong was called for an illegal event property type");
        }
        return null;
    }

    public String[] getDateTimeArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 15: {
                    return (String[])this.values;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getDateTimeArray was called for an illegal event property type");
        }
        return null;
    }

    public boolean[] getBooleanArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 16: {
                    return (boolean[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    boolean[] blArray = new boolean[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        blArray[n] = new Boolean(stringArray[n]);
                        ++n;
                    }
                    return blArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getBooleanArray was called for an illegal event property type");
        }
        return null;
    }

    public byte[] getByteArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 9: {
                    return (byte[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    byte[] byArray = new byte[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        byArray[n] = new Byte(stringArray[n]);
                        ++n;
                    }
                    return byArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getByteArray was called for an illegal event property type");
        }
        return null;
    }

    public short[] getShortArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 10: {
                    return (short[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    short[] sArray = new short[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        sArray[n] = new Short(stringArray[n]);
                        ++n;
                    }
                    return sArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getShortArray was called for an illegal event property type");
        }
        return null;
    }

    public int[] getIntArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 11: {
                    return (int[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    int[] nArray = new int[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        nArray[n] = new Integer(stringArray[n]);
                        ++n;
                    }
                    return nArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getIntArray was called for an illegal event property type");
        }
        return null;
    }

    public long[] getLongArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 12: {
                    return (long[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    long[] lArray = new long[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        lArray[n] = new Long(stringArray[n]);
                        ++n;
                    }
                    return lArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getLongArray was called for an illegal event property type");
        }
        return null;
    }

    public float[] getFloatArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 13: {
                    return (float[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    float[] fArray = new float[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        fArray[n] = new Float(stringArray[n]).floatValue();
                        ++n;
                    }
                    return fArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getFloatArray was called for an illegal event property type");
        }
        return null;
    }

    public double[] getDoubleArray() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 14: {
                    return (double[])this.values;
                }
                case 15: {
                    String[] stringArray = (String[])this.values;
                    double[] dArray = new double[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        dArray[n] = new Double(stringArray[n]);
                        ++n;
                    }
                    return dArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getDoubleArray was called for an illegal event property type");
        }
        return null;
    }

    public char[] getHexValues() {
        return this.getHexBinarys();
    }

    public char[] getHexBinarys() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 18: {
                    return (char[])this.values;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getHexBinarys was called for an illegal event property type");
        }
        return null;
    }

    public byte[] getHexValue() {
        return this.getHexBinary();
    }

    public byte[] getHexBinary() {
        if (this.values != null) {
            switch (this.valuesType) {
                case 18: {
                    char[] cArray = (char[])this.values;
                    byte[] byArray = new byte[cArray.length];
                    int n = 0;
                    while (n < cArray.length) {
                        byArray[n] = cArray[n] > '\u00ff' ? 127 : (byte)(cArray[n] - 128);
                        ++n;
                    }
                    return byArray;
                }
            }
            throw new InvalidExtendedDataElementTypeException("getHexBinarys was called for an illegal event property type");
        }
        return null;
    }

    public void setString(String string) {
        this.values = string;
        this.type = 6;
        this.valuesType = 6;
    }

    public void setDateTime(long l) {
        this.values = CbeFormatter.convertDateToXmlSchemaDateTime(l);
        this.type = 8;
        this.valuesType = 6;
    }

    public void setDateTime(String string) {
        this.values = string;
        this.type = 8;
        this.valuesType = 6;
    }

    public void setBoolean(boolean bl) {
        this.values = new Boolean(bl);
        this.type = 7;
        this.valuesType = 7;
    }

    public void setByte(byte by) {
        this.values = new Byte(by);
        this.type = 0;
        this.valuesType = 0;
    }

    public void setShort(short s) {
        this.values = new Short(s);
        this.type = 1;
        this.valuesType = 1;
    }

    public void setInt(int n) {
        this.values = new Integer(n);
        this.type = 2;
        this.valuesType = 2;
    }

    public void setLong(long l) {
        this.values = new Long(l);
        this.type = 3;
        this.valuesType = 3;
    }

    public void setFloat(float f) {
        this.values = new Float(f);
        this.type = 4;
        this.valuesType = 4;
    }

    public void setDouble(double d) {
        this.values = new Double(d);
        this.type = 5;
        this.valuesType = 5;
    }

    public void setStringArray(String[] stringArray) {
        this.values = stringArray;
        this.type = 15;
        this.valuesType = 15;
    }

    public void setDateTimeArray(long[] lArray) {
        if (lArray != null) {
            String[] stringArray = new String[lArray.length];
            int n = 0;
            while (n < lArray.length) {
                stringArray[n] = CbeFormatter.convertDateToXmlSchemaDateTime(lArray[n]);
                ++n;
            }
            this.values = stringArray;
        } else {
            lArray = null;
        }
        this.type = 17;
        this.valuesType = 15;
    }

    public void setDateTimeArray(String[] stringArray) {
        this.values = stringArray;
        this.type = 17;
        this.valuesType = 15;
    }

    public void setBooleanArray(boolean[] blArray) {
        this.values = blArray;
        this.type = 16;
        this.valuesType = 16;
    }

    public void setByteArray(byte[] byArray) {
        this.values = byArray;
        this.type = 9;
        this.valuesType = 9;
    }

    public void setShortArray(short[] sArray) {
        this.values = sArray;
        this.type = 10;
        this.valuesType = 10;
    }

    public void setIntArray(int[] nArray) {
        this.values = nArray;
        this.type = 11;
        this.valuesType = 11;
    }

    public void setLongArray(long[] lArray) {
        this.values = lArray;
        this.type = 12;
        this.valuesType = 12;
    }

    public void setFloatArray(float[] fArray) {
        this.values = fArray;
        this.type = 13;
        this.valuesType = 13;
    }

    public void setDoubleArray(double[] dArray) {
        this.values = dArray;
        this.type = 14;
        this.valuesType = 14;
    }

    public void setHexBinarys(char[] cArray) {
        this.values = cArray;
        this.type = 18;
        this.valuesType = 18;
    }

    public void setHexBinary(byte[] byArray) {
        if (byArray != null) {
            char[] cArray = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                cArray[n] = (char)(byArray[n] + 128);
                ++n;
            }
            this.values = cArray;
        } else {
            byArray = null;
        }
        this.type = 18;
        this.valuesType = 18;
    }

    public void clearValues() {
        this.init();
    }

    public void init() {
        this.type = -1;
        this.name = null;
        this.id = null;
        this.values = null;
        this.valuesType = -1;
        this.children = null;
    }

    public boolean equals(Object object) {
        block40: {
            ExtendedDataElementImpl extendedDataElementImpl;
            block41: {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof ExtendedDataElementImpl)) break block40;
                extendedDataElementImpl = (ExtendedDataElementImpl)object;
                if ((this.name == null || !this.name.equals(extendedDataElementImpl.name)) && (this.name != null || extendedDataElementImpl.name != null) || this.type != extendedDataElementImpl.type || (this.children == null || !this.children.equals(extendedDataElementImpl.children)) && (this.children != null && this.children.size() != 0 || extendedDataElementImpl.children != null && extendedDataElementImpl.children.size() != 0)) break block40;
                if (this.values == null || extendedDataElementImpl.values == null) break block41;
                switch (this.valuesType) {
                    case 15: {
                        String[] stringArray;
                        String[] stringArray2;
                        if (extendedDataElementImpl.valuesType == 15 && (stringArray2 = (String[])this.values).length == (stringArray = (String[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < stringArray2.length) {
                                if (!stringArray2[n].equals(stringArray[n])) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 9: {
                        byte[] byArray;
                        byte[] byArray2;
                        if (extendedDataElementImpl.valuesType == 9 && (byArray2 = (byte[])this.values).length == (byArray = (byte[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < byArray2.length) {
                                if (byArray2[n] != byArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 10: {
                        short[] sArray;
                        short[] sArray2;
                        if (extendedDataElementImpl.valuesType == 10 && (sArray2 = (short[])this.values).length == (sArray = (short[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < sArray2.length) {
                                if (sArray2[n] != sArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 11: {
                        int[] nArray;
                        int[] nArray2;
                        if (extendedDataElementImpl.valuesType == 11 && (nArray2 = (int[])this.values).length == (nArray = (int[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < nArray2.length) {
                                if (nArray2[n] != nArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 12: {
                        long[] lArray;
                        long[] lArray2;
                        if (extendedDataElementImpl.valuesType == 12 && (lArray2 = (long[])this.values).length == (lArray = (long[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < lArray2.length) {
                                if (lArray2[n] != lArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 13: {
                        float[] fArray;
                        float[] fArray2;
                        if (extendedDataElementImpl.valuesType == 13 && (fArray2 = (float[])this.values).length == (fArray = (float[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < fArray2.length) {
                                if (fArray2[n] != fArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 14: {
                        double[] dArray;
                        double[] dArray2;
                        if (extendedDataElementImpl.valuesType == 14 && (dArray2 = (double[])this.values).length == (dArray = (double[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < dArray2.length) {
                                if (dArray2[n] != dArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 16: {
                        boolean[] blArray;
                        boolean[] blArray2;
                        if (extendedDataElementImpl.valuesType == 16 && (blArray2 = (boolean[])this.values).length == (blArray = (boolean[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < blArray2.length) {
                                if (blArray2[n] != blArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    case 18: {
                        char[] cArray;
                        char[] cArray2;
                        if (extendedDataElementImpl.valuesType == 18 && (cArray2 = (char[])this.values).length == (cArray = (char[])extendedDataElementImpl.values).length) {
                            int n = 0;
                            while (n < cArray2.length) {
                                if (cArray2[n] != cArray[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        break block40;
                    }
                    default: {
                        return this.values.equals(extendedDataElementImpl.values);
                    }
                }
            }
            if (this.values == null && extendedDataElementImpl.values == null) {
                return true;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("name", this.name);
        putField.put("type", this.type);
        putField.put("values", this.values);
        putField.put("valuesType", this.valuesType);
        if (this.children != null && !this.children.isEmpty()) {
            putField.put("children", this.children.toArray(new IExtendedDataElement[this.children.size()]));
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = null;
        getField = objectInputStream.readFields();
        this.name = (String)getField.get("name", this.name);
        this.type = getField.get("type", this.type);
        this.values = getField.get("values", this.values);
        this.valuesType = getField.get("valuesType", this.valuesType);
        Object[] objectArray = null;
        objectArray = (Object[])getField.get("children", null);
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.addChildDataElement((IExtendedDataElement)objectArray[n2]);
                ++n2;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedDataElementImpl extendedDataElementImpl = (ExtendedDataElementImpl)super.clone();
        Object var2_2 = null;
        if (this.children != null) {
            extendedDataElementImpl.children = (ArrayList)this.children.clone();
            int n = 0;
            while (n < this.children.size()) {
                var2_2 = this.children.get(n);
                if (var2_2 instanceof ExtendedDataElementImpl) {
                    extendedDataElementImpl.children.set(n, (IExtendedDataElement)((ExtendedDataElementImpl)var2_2).clone());
                }
                ++n;
            }
        }
        if (this.values != null) {
            switch (this.valuesType) {
                case 15: {
                    extendedDataElementImpl.values = ((String[])this.values).clone();
                    break;
                }
                case 9: {
                    extendedDataElementImpl.values = ((byte[])this.values).clone();
                    break;
                }
                case 10: {
                    extendedDataElementImpl.values = ((short[])this.values).clone();
                    break;
                }
                case 11: {
                    extendedDataElementImpl.values = ((int[])this.values).clone();
                    break;
                }
                case 12: {
                    extendedDataElementImpl.values = ((long[])this.values).clone();
                    break;
                }
                case 13: {
                    extendedDataElementImpl.values = ((float[])this.values).clone();
                    break;
                }
                case 14: {
                    extendedDataElementImpl.values = ((double[])this.values).clone();
                    break;
                }
                case 16: {
                    extendedDataElementImpl.values = ((boolean[])this.values).clone();
                    break;
                }
                case 18: {
                    extendedDataElementImpl.values = ((char[])this.values).clone();
                    break;
                }
                case 6: {
                    extendedDataElementImpl.values = new String((String)this.values);
                    break;
                }
                case 0: {
                    extendedDataElementImpl.values = new Byte((Byte)this.values);
                    break;
                }
                case 1: {
                    extendedDataElementImpl.values = new Short((Short)this.values);
                    break;
                }
                case 2: {
                    extendedDataElementImpl.values = new Integer((Integer)this.values);
                    break;
                }
                case 3: {
                    extendedDataElementImpl.values = new Long((Long)this.values);
                    break;
                }
                case 4: {
                    extendedDataElementImpl.values = new Float(((Float)this.values).floatValue());
                    break;
                }
                case 5: {
                    extendedDataElementImpl.values = new Double((Double)this.values);
                    break;
                }
                case 7: {
                    extendedDataElementImpl.values = new Boolean((Boolean)this.values);
                }
            }
        }
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, int n, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        extendedDataElementImpl.setString(string2);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, int n, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        extendedDataElementImpl.setStringArray(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setString(string2);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setStringArray(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithBooleanArrayValue(String string, boolean[] blArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setBooleanArray(blArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithBooleanValue(String string, boolean bl) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setBoolean(bl);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithByteArrayValue(String string, byte[] byArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setByteArray(byArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithByteValue(String string, byte by) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setByte(by);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDateArrayValue(String string, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setDateTimeArray(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDateAsLongValue(String string, long l) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setDateTime(l);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDatesAsLongValue(String string, long[] lArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setDateTimeArray(lArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDateValue(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setDateTime(string2);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDoubleArrayValue(String string, double[] dArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setDoubleArray(dArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDoubleValue(String string, double d) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setDouble(d);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithFloatArrayValue(String string, float[] fArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setFloatArray(fArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithFloatValue(String string, float f) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setFloat(f);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithHexValue(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        char[] cArray = new char[string2.length()];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = string2.charAt(n);
            ++n;
        }
        extendedDataElementImpl.setHexValues(cArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithHexValueAsByteArray(String string, byte[] byArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setHexValue(byArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithIntArrayValue(String string, int[] nArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setIntArray(nArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithIntValue(String string, int n) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setInt(n);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithLongArrayValue(String string, long[] lArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setLongArray(lArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithLongValue(String string, long l) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setLong(l);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithShortArrayValue(String string, short[] sArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setShortArray(sArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithShortValue(String string, short s) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setShort(s);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

