/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;

public class TraceInteractionUtils {
    public static void searchTRCProcesses(EObject object, TraceProcesses list, IProgressMonitor monitor) {
        TRCAgent agent;
        TRCProcess process;
        if (monitor.isCanceled()) {
            return;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler") && (process = TraceUtils.getProcess((TRCAgent)(agent = ((TRCAgentProxy)object).getAgent()))) != null && process.getInvocations() != null && process.getInvocations().size() > 0) {
            list.add(new TraceProcess(process));
        }
    }

    public static double getAbsoluteEntryTime(TRCFullMethodInvocation methodInvocation) {
        return TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent()) + methodInvocation.getEntryTime();
    }

    public static double getAbsoluteEntryTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() / 1000000.0;
        return delta + agent.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCProcess process) {
        return TraceInteractionUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCThread thread) {
        return TraceInteractionUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStartTime();
    }

    public static double getAbsoluteExitTime(TRCFullMethodInvocation methodInvocation) {
        double start = TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent());
        if (methodInvocation.getExitTime() != 0.0) {
            return start + methodInvocation.getExitTime();
        }
        if (methodInvocation.getInvokes() == null || methodInvocation.getInvokes().size() == 0) {
            return TraceInteractionUtils.getAbsoluteExitTime(methodInvocation.getThread());
        }
        TRCFullMethodInvocation lastCalled = (TRCFullMethodInvocation)methodInvocation.getInvokes().get(methodInvocation.getInvokes().size() - 1);
        if (lastCalled.getExitTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(lastCalled);
        }
        return start + lastCalled.getExitTime();
    }

    public static double getAbsoluteExitTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() / 1000000.0;
        return delta + agent.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCProcess process) {
        if (process.getStopTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(process.getAgent());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCThread thread) {
        if (thread.getStopTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(thread.getProcess().getAgent());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStopTime();
    }

    public static boolean matchCharacter(char c1, char c2, boolean isCaseSensitive) {
        return c1 == c2 || !isCaseSensitive && Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static boolean trailingStars(String s, int l) {
        int i = l;
        while (i < s.length() && s.charAt(i) == '*') {
            ++i;
        }
        return i == s.length();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matchCriteria(String s, Criteria criteria) {
        e = criteria.getExpression();
        if (TraceSDPlugin.debugMatch) {
            TraceSDPlugin.debugTraceMatch("Comparing " + s + " to " + e);
        }
        i = 0;
        j = 0;
        while (i < s.length() && j < e.length()) {
            block17: {
                block16: {
                    sc = s.charAt(i);
                    ec = e.charAt(j);
                    if (TraceSDPlugin.debugMatch) {
                        TraceSDPlugin.debugTraceMatch("s[" + i + "]=" + sc + " e[" + j + "]=" + ec);
                    }
                    if (ec != '*') break block16;
                    if (j + 1 == e.length()) {
                        if (TraceSDPlugin.debugMatch) {
                            TraceSDPlugin.debugTraceMatch("#1a true");
                        }
                        return true;
                    }
                    k = 1;
                    while (j + k < e.length()) {
                        if (e.charAt(j + k) == '*' || e.charAt(j + k) == '?') {
                            j += k;
                            i += k - 2;
                            break;
                        }
                        if (!TraceInteractionUtils.matchCharacter(s.charAt(i + k - 1), e.charAt(j + k), criteria.isCaseSenstiveSelected())) {
                            i += k - 1;
                            break;
                        }
                        ++k;
                    }
                    if (i + k - 1 == s.length() && j + k == e.length()) {
                        if (TraceSDPlugin.debugMatch) {
                            TraceSDPlugin.debugTraceMatch("#1b true");
                        }
                        return true;
                    }
                    break block17;
                }
                if (ec != '?') ** GOTO lbl40
                if (i + 1 < s.length() && j + 1 < e.length()) {
                    ++j;
                } else {
                    if (TraceSDPlugin.debugMatch) {
                        TraceSDPlugin.debugTraceMatch(i + 1 == s.length() && TraceInteractionUtils.trailingStars(e, j + 1) != false ? "#3 true" : "#3 false");
                    }
                    return i + 1 == s.length() && TraceInteractionUtils.trailingStars(e, j + 1) != false;
lbl40:
                    // 1 sources

                    if (!TraceInteractionUtils.matchCharacter(sc, ec, criteria.isCaseSenstiveSelected())) {
                        if (TraceSDPlugin.debugMatch) {
                            TraceSDPlugin.debugTraceMatch("#4 false");
                        }
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (TraceSDPlugin.debugMatch) {
            TraceSDPlugin.debugTraceMatch(i == s.length() && (j == e.length() || j + 1 == e.length() && (e.charAt(j) == '*' || e.charAt(j) == '?')) ? "#5 true" : "#5 false");
        }
        return i == s.length() && TraceInteractionUtils.trailingStars(e, j) != false;
    }
}

