/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.util;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.util.*;

/**
 * This class is used to convert a deployment resource created by Hyades 1.2 release
 * or earlier to the new version that is editablbe by deployment editor in Hyades 1.3 or later.
 * 
 * @author bjiang
 * @since	1.3
 */
public class DeploymentCompatibilityConverter
{
	public static void convert(TPFDeployment deployment) throws Exception
	{
		EList oldLocations = deployment.getLocations();
		if(oldLocations.isEmpty())
			return;
			
		CFGMachine[] oldMachines = new CFGMachine[oldLocations.size()];
		int index = 0;
		for(Iterator i = oldLocations.iterator(); i.hasNext();)
		{
			oldMachines[index] = (CFGMachine)i.next();
			index ++;
		}
		
		for(index = 0; index < oldMachines.length; index++)
		{
			String name = oldMachines[index].getName();
			String description = oldMachines[index].getDescription();
			String hostname = oldMachines[index].getHostName();
			
			
			
			CFGMachineConstraint newMachine = Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint();
			newMachine.setName(name);
			newMachine.setDescription(description);
			newMachine.setHostname(hostname);
	
			String filename = name + "." + ICommonConstants.LOCATION_FILE_EXTENSION; //$NON-NLS-1$	
			IFile deployFile = EMFUtil.getWorkspaceFile(deployment);
			IFile file = deployFile.getWorkspace().getRoot().getFile( deployFile.getParent().getFullPath().append(filename));

			Resource resource = LocationUtil.createResource(file);
			resource.getContents().add(newMachine);
			EMFUtil.save(resource);
	
			deployment.getRefLocations().add(newMachine);
			deployment.getLocations().remove(oldMachines[index]);
		}
	}
}
