/*``````````````````````````````````````````````````````````````/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */

package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.*;
import java.net.*;

/**
 * @author dmorris
 * modified by:  mddunn 11/17/2003 for Hyades-O 1.2
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ClientSideReaderHTTP extends ClientSideReader {
	
	public static final String ERROR_SSL_REQUEST_MADE = "-1"; //this is an error until SSL is supported
	public static final String ERROR_NO_TESTKEYS = "-2"; //this is an error until SSL is supported
	static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
	static int iConn = 0;
	static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

	String iProxyAddr = "";
	int iProxyPort = 0;	
	boolean secureConnectionOK = false;
	// try this mdd
	boolean didOpenConnection = false;
	boolean wroteOnePacket = false;
	
	ClientSideReaderHTTP(PeekSocket client, PacketWriter packetWriter,
			String keyFile, String proxyAddr, int proxyPort){
		super(client,packetWriter, keyFile);
		iProxyAddr = proxyAddr;
		iProxyPort = proxyPort;
	}

	public void run(){
		
		int bytes_read = 0;
		String strReturn = null;
		boolean isConnected = false;
		boolean isConnectRequest = false;
		byte[] tmpBuff = {21,3,0,0,2,2,10};
		 
		if (isSSLClassAvailable == -1)	{	
			isSSLClassAvailable = findSSLClass();
			if (isSSLClassAvailable == 1) {
				foundTestKeys = checkForTestKeys();
			}
		}

		this.setName("ClientSideReaderHTTP-"+"Conn:"+iConnection+":"+iProxyAddr+":"+iProxyPort);
		try {
			
			byte[] buffer = new byte[client.getReceiveBufferSize()];
	
				isConnected = connectToProxyServer();
			
			// TODO check for SSL Connection first before read
			//bSecure = checkSSLByte();
			if (isConnected ) {
				while ((bytes_read = from_client.read(buffer)) != -1){
					sleep(1);
					yield();
					bNoPrintToServer = false;
					int index = 0;
					String str = new String(buffer, 0, bytes_read);
					isConnectRequest  = checkForSSLRequest(str);
					wroteOnePacket = true;
					// If bSecure is set to true, leave it alone
					
					if (isConnectRequest){
						if (isSSLClassAvailable == 1)	{
							if (foundTestKeys) {
								SSLCheckClass thisSSLCheck = new SSLCheckClass(this, keyFile);
								to_server = httpServer.getOutputStream();
								from_server = httpServer.getInputStream();
								thisSSLCheck.makeSecureConnectionHTTP(str,iProxyAddr, iProxyPort);
							}
							else  {
								// send message to UI 
								packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
								return;
							}
						}					
					}
							
					// if (!bSecure)
					if (!bSecure && !didOpenConnection )
						strReturn = makeRegularConnection();
					
					if (bSecure){
						//packetWriter.writePacket(bSecure, true, iConnection, buffer, bytes_read);
						packetWriter.writePacket(bSecure, true, connectionNumber, buffer, bytes_read);
						if (!bNoPrintToServer){
							to_server.write(buffer, 0, bytes_read);
							to_server.flush();
						}
					}
					if (!bSecure){
						//packetWriter.writePacket(bSecure, true, iConnection, str.getBytes(), str.getBytes().length);
						packetWriter.writePacket(bSecure, true, connectionNumber, str.getBytes(), str.getBytes().length);
				
						if (!bNoPrintToServer && str.getBytes().length > 0){
							to_server.write(str.getBytes(), 0, str.getBytes().length);
							to_server.flush();
						}
					
					}
						
				}
			}  // isConnected is true 
			
			// mdd this moved to serversidereader 
			//packetWriter.writeCloseConnectionInfo(iConnection);
			if (httpServer != null){
				httpServer.setSoLinger(false,0);
				if (!wroteOnePacket) {
					if (! httpServer.isClosed()) {
						//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER A1 - CLOSED SERVERSIDE COnnection: " + iConnection);
						httpServer.close();
					}
				}
				else if (! httpServer.isOutputShutdown()){
					if (bSecure) {
						//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER A WRITING SSL CLOSE ALERT for COnnection: " + iConnection);
						to_server.write(tmpBuff, 0, 7);
						to_server.flush();
					} else {
						httpServer.shutdownOutput();
						//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER A - SHUTDOWN SERVERSIDE OUTPUT for COnnection: " + iConnection);
					}
				}
				//	mdd tell Server reader we are closed
				if (serverReader != null)
					serverReader.setClosedByClient();
			}
				
		}
		catch (Exception e) {
			// mdd add check 
			/* OLD WAY
			if (!httpServer.isClosed())
				packetWriter.writeCloseConnectionInfo(iConnection);
			try {
				if (httpServer != null) {
					if (!httpServer.isClosed())
						httpServer.close();
					// mdd tell Server reader we are closed	
					if (serverReader != null)
						serverReader.setClosedByClient();
				}
			}
			catch (IOException ioe){
				packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + ": "  + ioe);
			} */
			// NEW WAY
			//packetWriter.writeRecorderMessage(1, "JUST CAUGHT AN EXCEPTION In ClientSideReader connection " + iConnection + " Exception: " +e.getLocalizedMessage() );
			
			try {
				if (httpServer != null) {
					//if (!httpServer.isClosed())
					//	httpServer.close();
					if (!wroteOnePacket) {
						if (! httpServer.isClosed()) {
							//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER B1 - CLOSED SERVERSIDE COnnection: " + iConnection);
							httpServer.close();
						}
					} else 	if (!httpServer.isOutputShutdown()){
						if (bSecure) {
							//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER B WRITING SSL CLOSE ALERT for COnnection: " + iConnection);
							to_server.write(tmpBuff, 0, 7);
							to_server.flush();
						} else {
							httpServer.shutdownOutput();
							//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER B - SHUTDOWN SERVERSIDE OUTPUT for COnnection: " + iConnection);
						}
					}
					// mdd tell Server reader we are closed	
					// add check for null 032204
					//if (serverReader != null)	
						// MAT NEED serverReader.setClosedByClient();
				}
				
				yield();
				// force interrupt by nulling the buffer SSR is reading mdd
				//serverReader.interrupt();
				//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER NULL BUFFER FORCE INTERRUPT for COnnection: " + iConnection);
				//serverReader.ssrBuffer = null;
				
			}
			catch (IOException ioe){
				String mess = ioe.getMessage();
				// no record for the following exceptions, they are expected
				
				if (mess.indexOf("Stream closed") < 0 && mess.indexOf("Socket closed") < 0 &&
				    mess.indexOf("JVM_recv in socket input") <0 && mess.indexOf("onnection closed")<0
				    && mess.indexOf("socket closed")<0 && mess.indexOf("onnection reset") < 0
					&& mess.indexOf("Socket is closed") <0) {
						packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + " : " + e.getLocalizedMessage());
					}
			}
			// NEW WAY
		}
		
	}
	

	private boolean connectToProxyServer() {
		boolean isConnected = false;
		// now must connect to IP address

		try {
		
			httpServer = new Socket(iProxyAddr, iProxyPort);
			if (httpServer != null) {
				//respondToClient(true);
				isConnected = true;
			}
			else {
				isConnected = false;
				// TODO write error msg to log 
				//respondToClient(false);
				packetWriter.writeRecorderMessage(1, "Error connecting to Server:" + destServer + " Port: "+serverPort);
			}
		} catch (IOException ioe){
		packetWriter.writeRecorderMessage(1, "Error Connecting to Proxy Server:" + iProxyAddr + ":" + iProxyPort + ioe);
	}			
		
		return isConnected;
	} 
	
	private void respondToClient(boolean flag) {
		byte[] reply_buff = new byte[8];
	
		reply_buff[0] = 0;
		if (flag == true){
			reply_buff[1] = 90;
		}
		else {
			reply_buff[1] = 91;
		}
		try {
			to_client.write(reply_buff,0, 8);
			to_client.flush();
		} catch (Exception e){
		}
	}

	private boolean checkForSSLRequest(String request) {
		boolean returnCode = false;
		int index;
		// when a client connects to a proxy for SSL, we get a string of the following form from the client:
		//  CONNECT whateverssl.server.com:443\r\n
		// that is the string we must parse to do the SSL connection
		if ((index = request.indexOf("CONNECT ")) >= 0){
			// code here to connect to SSL server
			int indexEnd;
			returnCode = true;
			index += 8;  // go past the word CONNECT + space
			if ((indexEnd = request.indexOf(":", index)) > index){
				String destStr = request.substring(index, indexEnd);
				// now we have server string to go to in destStr, get the port
				index = indexEnd + 1; // next character after the colon 
				if ((indexEnd = request.indexOf(" ", index)) > index){
					int port;
					String portStr = request.substring(index, indexEnd);
					// now we have the port								
					port = Integer.parseInt(portStr);
					// now we can try to connect to the secure port
					destServer = destStr;
					serverPort = port;
					//packetWriter.writeOpenConnectionInfo(bSecure, iConnection, destStr, port, client, httpServer, null, null);
				}
			}
		}
		return returnCode;
	}

	private String makeRegularConnection( ){
		
		String strReturn = null;
		//int index;	
		//int port = 80;
		//String destStr = null;
		boolean bFoundMessage = false;	

		try{
			// Note : already have open port to server
			//httpServer = new Socket(destStr, port);
			packetWriter.writeOpenConnectionInfo(bSecure, iConnection, destServer, serverPort, client, httpServer, null, null);
						
			to_server = httpServer.getOutputStream();
			from_server = httpServer.getInputStream();
						
			serverReader = new ServerSideReader(client,
												httpServer,
												from_server,
												to_client,
												 packetWriter,
												 //iConnection,
												 connectionNumber,
												 bSecure,
												 httpServer.getReceiveBufferSize());
			serverReader.start();
	
		}
		catch (Exception e){
				packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + e);
				packetWriter.getAgentController().reportException(ClientSideReaderException,e);
				packetWriter.writeCloseConnectionInfo(connectionNumber);
				try {
					client.close();
					strReturn = null;
				}
				catch (IOException ioe){
					packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + ": "  + ioe);
				}
		}
		didOpenConnection = true;
		return strReturn;					
	}

}