/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

import java.util.ArrayList;
import java.util.List;


/**
 * @author slavescu
 */
public class AgentsContext {
    //~ Instance fields ----------------------------------------------------------------------------

    protected List agentList = new ArrayList();
    protected String id;
    protected TRCAgent currentAgent = null;

    //~ Constructors -------------------------------------------------------------------------------

    public AgentsContext(String id) {
        super();
        this.id = id;
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     *
     * @param peerAgent
     * @return the monitored or attached agent or the agent from the same monitor with peerAgent or the first agent from the list
     */
    public TRCAgent getActiveAgent(TRCAgent peerAgent) {
        if (agentList.isEmpty()) {
            return null;
        }

        try {
            if (currentAgent != null && currentAgent.getAgentProxy().isMonitored()) {
                return currentAgent;
            }
        } catch (Exception e) {
        	// do nothing
        }

        TRCAgent[] agents = (TRCAgent[]) agentList.toArray(new TRCAgent[agentList.size()]);

        for (int i = 0; i < agents.length; i++) {
            currentAgent = agents[i];

            try {
                if (currentAgent.getAgentProxy().isMonitored()) {
                    return currentAgent;
                }
            } catch (Exception e) {
            	// do nothing
            }
        }

        for (int i = 0; i < agents.length; i++) {
            currentAgent = agents[i];

            try {
                if (currentAgent.getAgentProxy().isAttached()) {
                    return currentAgent;
                }
            } catch (Exception e) {
            	// do nothing
            }
        }

        try {
            TRCMonitor monitor = peerAgent.getAgentProxy().getProcessProxy().getNode().getMonitor();

            if (monitor != null) {
                for (int i = 0; i < agents.length; i++) {
                    currentAgent = agents[i];

                    try {
                        if (currentAgent.getAgentProxy().getProcessProxy().getNode().getMonitor() == monitor) {
                            return currentAgent;
                        }
                    } catch (Exception e) {
                    	// do nothing
                    }
                }
            }
        } catch (Exception e) {
//        	 do nothing
        }

        return null;
    }

    /**
     * @return the list of registered agents that has the runtimeId==id
     */
    public List getAgentList() {
        return agentList;
    }

    public boolean deregisterAgent(TRCAgent agent) {
        if (currentAgent == agent) {
            currentAgent = null;
        }

        return agentList.remove(agent);
    }

    public boolean registerAgent(TRCAgent agent) {
    	if(agentList.contains(agent))
    		return false;
        return agentList.add(agent);
    }
	/**
	 * @return the runtimeID of this set of agents
	 */
	public String getId() {
		return id;
	}

}
