/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.util;

import java.util.Collection;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;

/**
 * @author slavescu
 */
public interface IHyadesResourceFactory extends Resource.Factory,IPagingListFactory{
	String LARGE_RESOURCE_SUPPORT_DB_TYPE = "largeResourceSupportDBType";
	String LRSP_USERNAME = "largeResourceSupportUsername";
	String LRSP_PASSWORD = "largeResourceSupportPassword";
	String LRSP_CACHE_SIZE = "largeResourceSupportCacheSize";
	
	boolean isEnabledFor(String postfix);
	String getStoreType(String postfix);
	
	IHyadesExtendedResource createResource(URI uri, Properties properties);
	IHyadesExtendedResource createResource(URI uri, Properties properties,Collection notLoaded);
	
	// creates the underlining DB tables
	boolean createTables(String storeType,Properties properties);
	// drops the underlining DB tables
	boolean dropTables(String storeType,Properties properties);
}
