/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Process Proxy</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The proxy for a real OS process. Has properties that represent the execution context. The reason this is referred to as a proxy is that if an agent is actually collecting an execution trace, it will contain the relevant details at runtime of the process that is being monitored.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getPid <em>Pid</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getClasspath <em>Classpath</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getParameters <em>Parameters</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLaunchMode <em>Launch Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getVmArguments <em>Vm Arguments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#isActive <em>Active</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getExecParameters <em>Exec Parameters</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getEnvironmentVariables <em>Environment Variables</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getNode <em>Node</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getAgentProxies <em>Agent Proxies</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy()
 * @model 
 * @generated
 */
public interface TRCProcessProxy extends EObject{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Runtime Id</em>' attribute.
	 * @see #setRuntimeId(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_RuntimeId()
	 * @model 
	 * @generated
	 */
	String getRuntimeId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getRuntimeId <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Runtime Id</em>' attribute.
	 * @see #getRuntimeId()
	 * @generated
	 */
	void setRuntimeId(String value);

	/**
	 * Returns the value of the '<em><b>Pid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Pid</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pid</em>' attribute.
	 * @see #setPid(int)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Pid()
	 * @model 
	 * @generated
	 */
	int getPid();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getPid <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pid</em>' attribute.
	 * @see #getPid()
	 * @generated
	 */
	void setPid(int value);

	/**
	 * Returns the value of the '<em><b>Classpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Classpath</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The process classpath
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Classpath</em>' attribute.
	 * @see #setClasspath(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Classpath()
	 * @model 
	 * @generated
	 */
	String getClasspath();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getClasspath <em>Classpath</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Classpath</em>' attribute.
	 * @see #getClasspath()
	 * @generated
	 */
	void setClasspath(String value);

	/**
	 * Returns the value of the '<em><b>Parameters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameters</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The process command-line parameters
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Parameters</em>' attribute.
	 * @see #setParameters(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Parameters()
	 * @model 
	 * @generated
	 */
	String getParameters();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getParameters <em>Parameters</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parameters</em>' attribute.
	 * @see #getParameters()
	 * @generated
	 */
	void setParameters(String value);

	/**
	 * Returns the value of the '<em><b>Launch Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Launch Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The launching mode for the current process,
	 * 1 if the trace was attached to the process, 0 if the
	 * process was launched by the trace process.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Launch Mode</em>' attribute.
	 * @see #setLaunchMode(int)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_LaunchMode()
	 * @model 
	 * @generated
	 */
	int getLaunchMode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLaunchMode <em>Launch Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Launch Mode</em>' attribute.
	 * @see #getLaunchMode()
	 * @generated
	 */
	void setLaunchMode(int value);

	/**
	 * Returns the value of the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Location</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The initial current directory for the process
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Location</em>' attribute.
	 * @see #setLocation(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Location()
	 * @model 
	 * @generated
	 */
	String getLocation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLocation <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Location</em>' attribute.
	 * @see #getLocation()
	 * @generated
	 */
	void setLocation(String value);

	/**
	 * Returns the value of the '<em><b>Vm Arguments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Vm Arguments</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Vm Arguments</em>' attribute.
	 * @see #setVmArguments(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_VmArguments()
	 * @model 
	 * @generated
	 */
	String getVmArguments();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getVmArguments <em>Vm Arguments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Vm Arguments</em>' attribute.
	 * @see #getVmArguments()
	 * @generated
	 */
	void setVmArguments(String value);

	/**
	 * Returns the value of the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Active</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Active</em>' attribute.
	 * @see #setActive(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Active()
	 * @model 
	 * @generated
	 */
	boolean isActive();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#isActive <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Active</em>' attribute.
	 * @see #isActive()
	 * @generated
	 */
	void setActive(boolean value);

	/**
	 * Returns the value of the '<em><b>Exec Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCExecParameter}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCExecParameter#getProcessProxy <em>Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Exec Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Exec Parameters</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_ExecParameters()
	 * @see org.eclipse.hyades.models.hierarchy.TRCExecParameter#getProcessProxy
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCExecParameter" opposite="processProxy" containment="true"
	 * @generated
	 */
	EList getExecParameters();

	/**
	 * Returns the value of the '<em><b>Environment Variables</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getProcessProxy <em>Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Environment Variables</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Environment Variables</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_EnvironmentVariables()
	 * @see org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getProcessProxy
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable" opposite="processProxy" containment="true"
	 * @generated
	 */
	EList getEnvironmentVariables();

	/**
	 * Returns the value of the '<em><b>Node</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getProcessProxies <em>Process Proxies</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Node</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Node</em>' reference.
	 * @see #setNode(TRCNode)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_Node()
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getProcessProxies
	 * @model opposite="processProxies"
	 * @generated
	 */
	TRCNode getNode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getNode <em>Node</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Node</em>' reference.
	 * @see #getNode()
	 * @generated
	 */
	void setNode(TRCNode value);

	/**
	 * Returns the value of the '<em><b>Agent Proxies</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProcessProxy <em>Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Agent Proxies</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Agent Proxies</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCProcessProxy_AgentProxies()
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProcessProxy
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCAgentProxy" opposite="processProxy" containment="true"
	 * @generated
	 */
	EList getAgentProxies();

} // TRCProcessProxy
