package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Destroy Situation</b></em>'.
 * <P>
 * The DestroySituation deals with the situations documenting when an entity 
 * or component was removed or destroyed. Messages telling that a document was 
 * destroyed or a file was deleted all fall into this category. Existing 
 * message include words like "was created", "about to create", and "now exists", 
 * for example:
 * </P>
 * <P>
 * <code>
 * CONM6007I: The connection pool was destroyed for data source 
 * (UDDI.Datasource.techs8.server1).
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.DestroySituation#getSuccessDisposition <em>Success Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getDestroySituation()
 * @model 
 * @generated
 */
public interface DestroySituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getDestroySituation_SuccessDisposition()
     * @model required="true"
     * @generated
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.DestroySituation#getSuccessDisposition <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies whether or not the operation that
     * caused the situation to be reported was successful.
     * The successDisposition is a string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * 
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Success Disposition</em>' attribute.
     * @see #getSuccessDisposition()
     * @generated
     */
    void setSuccessDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // DestroySituation
