/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * @author sleeloy
 *
 * This action class correlates an apache access log.  A time-based correlation is 
 * used.
 */
public class CorrelateLogAction implements IRunnableWithProgress{

	private final String corrName = LogCorrelatorPlugin.getResourceString("CORR_NAME");

	private EObject mofObject;
	/**
	 * Returns the Mof object that represents the access log file.  This object will be correlated.
	 * @see org.eclipse.hyades.log.ui.internal.actions.OpenLogViewAction#getMofObject()
	 * @return EObject represents the access log file that will be correlated.
	 */
	public EObject getMofObject() {
		return mofObject;
	}
	
	/**
	 * Sets the Mof object that represents the access log file.  This object will be correlated.
 	 * @param EObject represents the access log file that will be correlated.
 	 */
	public void setMofObject(EObject eobject){
		this.mofObject = eobject;
		
	}

	/**
	 * The run method that updates the user of its progress.
	 * 
	 * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void run(IProgressMonitor monitor)
		throws InvocationTargetException, InterruptedException {
			monitor.worked(1);
			this.run();
			monitor.done();
	}

	/**
	 * This method does all the work.  The access log will be correlated based on Time.
	 * 
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (mofObject != null && mofObject instanceof EObject) {
			IWorkbenchPage persp = UIPlugin.getActivePage();

			try {
				IConfigurationElement timeBased = CorrelationHelper.getInstance().getCorrelationByName(corrName);

				if(timeBased!=null){
					CorrelationContainerProxy proxy = CorrelationHelper.getInstance().createCorrelationContainer(timeBased,mofObject,corrName);
					Navigator nav = (Navigator)HyadesUtil.getActiveNavigator();
					nav.selectReveal(new StructuredSelection(proxy));						
					SDView view = view = (SDView) persp.showView("org.eclipse.hyades.uml2sd.ui.view.SDView"); //$NON-NLS-1$;
					LoadersManager.getLoadersManager().createLoader("org.eclipse.hyades.sd.logc.internal.loader.LogInteractions", getClass().getClassLoader(), view);
					((LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader()).generateLogInteractions(proxy,false);
					
					
					//((LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader()).generateLogInteractions(proxy,false);
				}
				
			} catch (Exception e) {
				String msg = SDLogcPlugin.getResourceString("STR_LOAD_SD_ERR_");
				Status err =
					new Status(
						Status.WARNING,
						ResourcesPlugin.PI_RESOURCES,
						IResourceStatus.INTERNAL_ERROR,
						e.toString(),
						null);
				IWorkbenchWindow window = SDLogcPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
				ErrorDialog.openError(window.getShell(), msg, "", err);
				e.printStackTrace();
			}
		}
		mofObject = null;
	}
	
	/**
	 * Cleans up all resources.
	 *
	 */
	public void dispose(){
	}
		

}
