/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

/**
 * 
 *
 */
public class LogCorrelatorPlugin extends Plugin {

    /**
     * 
     */
    private static LogCorrelatorPlugin inst;
    private static ResourceBundle aResourceBundle;

    public static String PLUGIN_ID;

    /**
     * 
     * @param descriptor
     */
    public LogCorrelatorPlugin(IPluginDescriptor descriptor) {

        super(descriptor);

        //**** cash the Plugin and the resource bundle instances
        if (inst == null)
            inst = this;
        aResourceBundle = this.getDescriptor().getResourceBundle();

    }
    public static LogCorrelatorPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static ResourceBundle getResourceBundle() {
        return aResourceBundle;
    }
    public static String getResourceString(String key) {
        ResourceBundle bundle = LogCorrelatorPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }
    
	public static String getResourceString(String key, String[] variables) {
		String value = getResourceString(key);
		for(int i=variables.length; i>0; i--)
			value = StringUtil.change(value, "%"+i, variables[i-1]);
		return value;
	}
    
}