/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

/**
 * <code>ReturnData</code> instances store data that is needed to marshal
 * or unmarshal values that are to be returned as a result of a method
 * invocation.
 */
public class ReturnData extends MarshalData {
	
	private Object returnValue;
	private boolean isError;
	
	/**
	 * @param targetId the unique id associated with the target object
	 * @param argTypes the list of types matching those declared as parameters
	 *        in the signature of <code>call</code> 
	 * @param call the method that is to be invoked
	 * @param returnValue the value returned from <code>call</code>. If this
	 *        value is assignment compatible with <code>Throwable</code>, the
	 *        <code>ReturnData</code> instance to be created represents an
	 *        exception that has been thrown as a result of <code>call</code>
	 *        having been invoked. If <code>call</code> returns a primitive
	 *        type, <code>returnValue</code> should be a wrapper object of the
	 *        appropriate type. If <code>call</code> does not return a value,
	 *        <code>returnValue</code> can be <code>null</code>.
	 */
	public ReturnData(Integer targetId, Class[] argTypes, String call, Object returnValue) {
		super(targetId, argTypes, call);
		this.returnValue = returnValue;
		if ( returnValue instanceof Throwable )
			isError = true;
	}

	/**
	 * Get the return value resulting from a method invocation.
	 * 
	 * @return an <code>Object</code> if the method that was invoked is one
	 *         that returns a value or if the invocation resulted in an
	 *         exception being thrown, or <code>null</code> if the method
	 *         does not return a value
	 */
	public Object getReturnValue() {
		return returnValue;
	}

	/**
	 * Indicates whether or not this instance wraps an exception that has
	 * been thrown.
	 * 
	 * @return <code>false</code> if an exception was not thrown,
	 *         <code>true</code> if the value wrapped by this instance is
	 *         assignment compatible with <code>Throwable</code>
	 */
	public boolean isError() {
		return isError;
	}

}
