/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.local;

import org.eclipse.hyades.internal.execution.recorder.remote.RecorderExecutableObjectAdapter;

/**
 * This object is called for special setup of the recorder executableobject.  It passes the 
 * classpath of the RecorderAgent and can provide arguments which will be used as VMArgs when 
 * the jvm is started for the recorder
 * @author Ernest Jessee
 */
public class HttpRecorderExecutableObjectAdapter extends RecorderExecutableObjectAdapter
{	
	
	/**
	 * return the Recorder agent full path
	 */
	public String getAgentClassPath()
	{
		return "org.eclipse.hyades.execution.recorder.http.remote.SSLProxyRecorder";//$NON-NLS-1$
	}

	
	/**
	 * returns any VMArgs which should be use when the recorder is started.
	 */
	public String getVMArgString()
	{
		String debugPort = System.getProperty("debugPort");	//$NON-NLS-1$	
		String debugParam="";//$NON-NLS-1$
		if(debugPort!=null)
		{
				debugParam+="-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address="+debugPort;//$NON-NLS-1$
		}
		return debugParam;
	}

}
