/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;
import java.net.*;

import org.eclipse.hyades.model.statistical.impl.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

import org.eclipse.hyades.statistical.ui.editor.internal.ImageRegistryProvider;

import java.lang.reflect.*;

import org.eclipse.hyades.statistical.ui.Debugger;

/**
 * The main plugin class to be used in the desktop.
 */
public class EditorPlugin extends AbstractUIPlugin {

	public static final String PACKAGE_DEBUGGER = "org.eclipse.hyades.statistical.ui";
	public static final String PACKAGE_STATCON_MODULE = "org.eclipse.hyades.statistical.ui.StatConModule";
	public static final String PACKAGE_STATCON_FILE = "org.eclipse.hyades.statistical.ui.StatConFile";

	//The shared instance.
	private static EditorPlugin plugin;

	public static Debugger DBG = new Debugger(PACKAGE_DEBUGGER);

	//Resource bundle.
	private static ResourceBundle resourceBundle;

	public static ImageManager img = new ImageManager();
	
	public static void disposeObject(Object o) throws Throwable {
		Class c = o.getClass();

		Throwable error = null;
							
		while (c != null) {				
			try {
				Method o_dispose = c.getDeclaredMethod("dispose",new Class[]{});
				o_dispose.setAccessible(true);
				o_dispose.invoke(o,new Object[]{});
				error = null;
				break;
			} catch (Throwable e) { 
				error = e;
			}
			c = c.getSuperclass();
		}
		
		if (error != null) throw error;
	}

	/**
	 * The constructor.
	 */
	public EditorPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		DBG.setPlugin(this);
		
		EditorPlugin.DBG.info("StatCon Plugin Constructor");

		try {
			img.initialize(new URL(getDescriptor().getInstallURL(),"icons/full/"), ImageRegistryProvider.createImageRegistry());
			img.addImages();
		} catch (Exception e) {
			e.printStackTrace();
		}
/*
		try {
			EditorPlugin.DBG.info("initializing images");
			img.initialize(new URL(getDescriptor().getInstallURL(),"icons/full/"), getImageRegistry());

			img.addImages();
		} catch (Exception e) {
			e.printStackTrace();
		}
*/		
		resourceBundle = this.getDescriptor().getResourceBundle();

		plugin = this;

		resourceBundle = getResourceBundle();

	}

private static String infopops_id = null;

	public static String getInfopopsId() {
		if (infopops_id == null) {
			try {
				infopops_id = Platform.getPlugin("org.eclipse.hyades.statistical.ui").getDescriptor().getUniqueIdentifier();
				DBG.info("Infopops Plugin ID = "+infopops_id);
			} catch (Throwable t) {
				DBG.logVisibleError(t,getString("ERROR_NO_INFOPOPS_ID"),false);
				infopops_id = "org.eclipse.hyades.statistical.ui";
			}
		}
		return infopops_id;
	}

	public void startup() throws CoreException {
		super.startup();
		EditorPlugin.DBG.info("calling StatisticalPackageImpl.init() to fix bugs");
		StatisticalPackageImpl.init();
	}  

	/**
	 * Returns the shared instance.
	 */
	public static EditorPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getString(String key)
	{
		try {
			return resourceBundle.getString(key);
		} catch (NullPointerException e) {
			return key;
		} catch (MissingResourceException e) {
			return key;
		}	
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	public static Shell getActiveWorkbenchShell() {
		return getActiveWorkbenchWindow().getShell();
	}
	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}

}
