/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;

import org.eclipse.ui.part.*;
import org.eclipse.ui.*;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.*;
import org.eclipse.emf.common.util.*;

import org.eclipse.hyades.model.statistical.*;
import org.eclipse.hyades.statistical.ui.EditorPlugin;

import java.util.*;
import java.io.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;

public class StatisticalModelEditor extends EditorPart implements DisposeListener {

IEditorSite site;
IFileEditorInput input;	
IFile file;

/* the statistical model (assumed to contain graphable aggregations) */
ArrayList sdroots = new ArrayList();
StatisticalModelGraphViewer agg_editor;

ArrayList disposables = new ArrayList();

	public void widgetDisposed(DisposeEvent e) {
		dispose();	
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		this.setSite(site);
		this.setInput(input);
		
		this.site = site;
		this.input = (IFileEditorInput)input;

		EditorPlugin.DBG.info("StatisticalModelEditor: got input");
		
		file = this.input.getFile();
	
		try {
			EditorPlugin.DBG.info("StatisticalModelEditor: loading file");
			load(file);	
		} catch (CoreException e) {
			e.printStackTrace();
			throw new PartInitException("An error occurred:"+e.getMessage());
		} catch (IOException e) {
			e.printStackTrace();
			throw new PartInitException("An I/O error occurred:"+e.getMessage());
		}
		if (sdroots.size() == 0) {
			throw new PartInitException("no statistical model found in file");
		}
	}
	
	
	
	public void load(IFile file) throws CoreException, IOException {

		if (file == null) {
			throw new IOException("NULL file!");
		}

		EditorPlugin.DBG.info("StatisticalModelEditor: creating ResourceSetImpl");

		ResourceSet resourceSet = new ResourceSetImpl();
						
		URI fileURI = URI.createPlatformResourceURI(file.getFullPath().toString());

EditorPlugin.DBG.info("StatisticalModelEditor file URI:"+fileURI);

		if (fileURI == null) throw new IOException("Null fileURI while loading statistical model");

		EditorPlugin.DBG.info("StatisticalModelEditor: getting resource");
		
		Resource resource = resourceSet.getResource(fileURI,false);
		
		if (resource == null) {

			EditorPlugin.DBG.info("StatisticalModelEditor: creating resource");
			resource = resourceSet.createResource(fileURI);
		}

		EditorPlugin.DBG.info("StatisticalModelEditor: created resource");

		if (resource == null) {
			throw new IOException("NULL resource!");
		}

		EditorPlugin.DBG.info("StatisticalModelEditor: created resource not NULL");
//		ResourceSetImpl r = null;
//		r.getResource(fileURI,false);
	//	r.load(file.getContents(),Collections.EMPTY_MAP);
//		resource.load(file.getContents(),Collections.EMPTY_MAP);

//		resource = resourceSet.getResource(fileURI,false);

		resource.load(Collections.EMPTY_MAP);

		EditorPlugin.DBG.info("StatisticalModelEditor: loaded resource");

		EList list = resource.getContents();

		EditorPlugin.DBG.info("StatisticalModelEditor: got contents of resource "+list.size());
		
		for (int i = 0; i < list.size(); i++) {
			Object o = list.get(i);

			if (o instanceof SDDescriptor) {
EditorPlugin.DBG.info("StatisticalModelEditor: adding SDDescriptor as root");
				sdroots.add(o);
			} else if (o instanceof EObject) {
				EObject curr = (EObject)o;
				EList direct_children = curr.eContents();
				
				for (int k = 0; k < direct_children.size(); k++) {
					Object co = direct_children.get(k);
					
					if (co instanceof SDDescriptor) {
EditorPlugin.DBG.info("StatisticalModelEditor: adding depth-1 child SDDescriptor as root");
						sdroots.add(co);	
					}
				}
				
			}
		}
		
	}

	
	public void createPartControl(Composite parent) {
		System.gc();

		long free= Runtime.getRuntime().freeMemory();
//		long max = Runtime.getRuntime().maxMemory();
		long total = Runtime.getRuntime().totalMemory();
		
		double d = total-free;
		d = d / (double)total;
		d = d * 100.0d;
		
		System.err.println("MEMORY USED = "+((total-free)/1024)+"k ("+d+"%)");

		parent.addDisposeListener(this);

		EditorPlugin.DBG.info("CALLING TAB FOLDER CONSTRUCTOR");
//		TabFolder tabfolder = new TabFolder(parent,0);
//		agg_editor = new StatisticalModelGraphViewer(tabfolder,0);

		//set the overall statcon infopop
		org.eclipse.ui.help.WorkbenchHelp.setHelp(parent,EditorPlugin.getInfopopsId()+".statcon_anywhere");
		agg_editor = new StatisticalModelGraphViewer(parent,0,false);

		for (int i = 0; i < sdroots.size(); i++) {
			EditorPlugin.DBG.info("THIS ADD MODEL CALL HAS BEEN REMOVED - THIS CLASS IS OBSOLETE AND SHOULD NOT BE BEING USED");
//			agg_editor.addModel((SDDescriptor)sdroots.get(i));			
		}
		
		disposables.add(agg_editor);
	}
		
	public void dispose() {
		super.dispose();
		EditorPlugin.DBG.info(getClass()+":disposed");
		for (int i = 0; i < disposables.size(); i++) {
			try {
			Object o = disposables.get(i);
			if (o != null) {
				if (o instanceof Widget) {
					((Widget)o).dispose();	
				} else if (o instanceof Color) {
					((Color)o).dispose();	
				} else if (o instanceof Image) {
					((Image)o).dispose();	
				} else {
					try {
						EditorPlugin.disposeObject(o);
					} catch (Throwable e) {
						EditorPlugin.DBG.info("Class not found when disposing of "+o);
					}
				}
			}
			} catch (Throwable e) {
				e.printStackTrace();
			}
		}		
	}
	
	public void doSave(IProgressMonitor monitor) {
		//do nothing
	}

	public void doSaveAs() {
		//do nothing
	}

	public void gotoMarker(IMarker marker) {
	}
		
	public boolean isSaveAsAllowed() {
		return false;
	}
	
	public boolean isDirty() {
		return false;
	}
	
	public void setFocus() {
		//do nothing
	}
}