/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

public class TestGraphSource implements GraphSource {

public static final int SINE_WAVE = 0;
public static final int COSINE_WAVE = 1;


int type;
double min;
double max;

	public TestGraphSource(double min, double max, int type) {
		this.min = min;
		this.max = max;
		this.type = type;
	}
	
	public double getMin() {
		return min;
	}
	public double getMax() {
		return max;
	}
	public double getValueMin() {
		return 0;
	}
	public double getValueMax() {
		return 100;
	}	
	public double getValueAt(double x) {
		
		if (type == SINE_WAVE) {
			return 50d + (50d * (double)Math.sin(Math.toRadians(x/60)));
		} else if (type == COSINE_WAVE) {
				return 50d + (50d * (double)Math.cos(Math.toRadians(x/60)));
		} else {
			return 0;
		}
		
	}
	
	public double getAverageBetween(double x, double x2) {
		return getValueAt(x);	
	}
	
	public double getSumBetween(double x, double x2) {
		return getValueAt(x);	
	}
}