/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.internal;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import org.eclipse.hyades.statistical.ui.*;

public class BaseImageManager {
	private URL iconBaseURL;
	private ImageRegistry imageRegistry;
	private boolean loaded = false;


	protected void addImages() {
	}
	
	public void initialize(URL iconBaseURL, ImageRegistry imageRegistry) {
		this.iconBaseURL = iconBaseURL;
		this.imageRegistry = imageRegistry;
//		Throwable t = new Throwable("BASE IMAGE MANAGER - IMAGE REGISTRY INITIALIZED, null="+(imageRegistry==null));
//		t.printStackTrace();
	}
	
	private void loadImages() {
		if (!loaded) {
			addImages();
			loaded = true;
		}
	}
	
	protected void add(String prefix, String name) {
		ImageDescriptor imageDescriptor = null;
		try {
			imageDescriptor = ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
		} catch (MalformedURLException e) {
			imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
		}

		if(imageDescriptor != null) {
			if (imageRegistry == null) EditorPlugin.DBG.error("IMAGE REGISTRY IS NULL!",new Throwable("null image registry"));
			imageRegistry.put(name, imageDescriptor);
		} else {
			EditorPlugin.DBG.error("Image "+prefix+" "+name+" NOT FOUND!");	
		}
	}
	
	private URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
		if (iconBaseURL == null) {
			throw new MalformedURLException();
		}
			
		StringBuffer buffer= new StringBuffer(prefix);
		buffer.append('/');
		buffer.append(name);
		return new URL(iconBaseURL, buffer.toString());
	}

	public ImageDescriptor getImageDescriptor(String key) {
		loadImages();
		return (ImageDescriptor)imageRegistry.getDescriptor(key);	
	}
	
	public Image getImage(String key) {
		loadImages();
		return imageRegistry.get(key);
	}

}
