/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import org.eclipse.hyades.statistical.ui.*;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ZoomIndicator extends Object
{
    ZoomSlider slider = null;
    
    double value;

    double oldValue;
    
    Color color;
    Color xorColor;
    
    public ZoomIndicator(ZoomSlider slider)
    {
        this.slider = slider;
        
        setColor(slider.getDisplay().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
        
        setValue(slider.getMinLimit());
        
        slider.addZoomIndicator(this);
    }
    
    public ZoomIndicator(ZoomSlider slider, double value)
    {
        this(slider);
        
        setValue(value);
        
        slider.redraw();
    }    
    
     
    public ZoomIndicator(ZoomSlider slider, Color color)
    {
        this(slider);
        
        setColor(color);
        
        slider.redraw();
    }    
    
    public ZoomIndicator(ZoomSlider slider, double value, Color color)
    {
        this(slider, value);
        
        setColor(color);
        
        slider.redraw();
    }
    
    public void setZoomSlider(ZoomSlider slider)
    {
        this.slider = slider;
    }

    public ZoomSlider getZoomSlider()
    {
        return slider;
    }    
    
    public void setValue(double value)
    {
        oldValue = this.value;
        
        if (value > slider.getMaxLimit()) value = slider.getMaxLimit();
		if (value < slider.getMinLimit()) value = slider.getMinLimit();

        this.value = value;
    }
    
    public double getValue()
    {
        return value;
    }    
    
    public void setColor(Color color)
    {
        this.color = color;
        
        setXORColor();
    }
    
    public Color getColor()
    {
        return color;
    }    

    public void paint(GC g, Image backBuffer, int pos, int w)
    {
        int pix = 0;
        int oldPix = 0;

        pix = (int)slider.value2Pixel(value);
        oldPix = (int)slider.value2Pixel(0);

		int orientation = slider.getOrientation();
		int direction = slider.getDirection();
		int size_height = slider.getBounds().height;
		int size_width = slider.getBounds().width;
        
        if (backBuffer == null)
        {
            if (g == null) 
            {
            	EditorPlugin.DBG.warning("indicator - graphics null");
            }

            g.setBackground(xorColor);                                    

            g.setXORMode(true);
            
            if (orientation == ZoomSlider.VERTICAL)
            {
                if (direction == ZoomSlider.INCREASING)
                {
                    g.fillRectangle(pos, pix, w, Math.abs(pix-oldPix));
                }
                else
                {
                    g.fillRectangle(pos, oldPix, w, Math.abs(pix-oldPix));
                }    
            }
            else
            {
                if (direction == ZoomSlider.INCREASING)
                {
                    g.fillRectangle(pix, pos, Math.abs(pix-oldPix), w);
                }
                else
                {
                    g.fillRectangle(oldPix, pos, Math.abs(pix-oldPix), w);
                }
            }    
            g.setXORMode(false);
        }    
        else
        {
            if (value != oldValue)
            {
                if (orientation == ZoomSlider.VERTICAL)
                {
                    g.setClipping(pos, 0, w, size_height);
                }
                else
                {
                    g.setClipping(0, pos, size_width, w);
                }
                    
                g.drawImage(backBuffer, 0, 0);
        
                g.setClipping(0, 0, size_width, size_height);

                g.setBackground(xorColor);

                g.setXORMode(true);

                if (orientation == ZoomSlider.VERTICAL)
                {
                    if (direction == ZoomSlider.INCREASING)
                    {
                        g.fillRectangle(pos, pix, w, Math.abs(pix-oldPix));
                    }
                    else
                    {
                        g.fillRectangle(pos, oldPix, w, Math.abs(pix-oldPix));
                    }    
                }
                else
                {
                    if (direction == ZoomSlider.INCREASING)
                    {
                        g.fillRectangle(pix, pos, Math.abs(pix-oldPix), w);
                    }
                    else
                    {
                        g.fillRectangle(oldPix, pos, Math.abs(pix-oldPix), w);
                    }
                }
                g.setXORMode(false);
            }    
        }    
    }    
    
    public void setXORColor()
    {
        RGB rgb1 = color.getRGB();
        RGB rgb2 = slider.getBackground().getRGB();
        
        String [] color1BinaryString = {Integer.toBinaryString(rgb1.red), Integer.toBinaryString(rgb1.green), Integer.toBinaryString(rgb1.blue)};
        String [] color2BinaryString = {Integer.toBinaryString(rgb2.red), Integer.toBinaryString(rgb2.green), Integer.toBinaryString(rgb2.blue)};
        
       	for (int i=0; i<3; i++)
       	{
       		while (color1BinaryString[i].length() < 8)
       		{
       			color1BinaryString[i] = "0" + color1BinaryString[i];
       		}
       	}
       	
       	for (int i=0; i<3; i++)
       	{
       		while (color2BinaryString[i].length() < 8)
       		{
       			color2BinaryString[i] = "0" + color2BinaryString[i];
       		}
       	}

		StringBuffer [] color3BinaryStringBuffer = new StringBuffer[3];
		
		for (int i=0; i<3; i++)
		{
			color3BinaryStringBuffer[i] = new StringBuffer();
			
			char [] color1CharArray = color1BinaryString[i].toCharArray();
			char [] color2CharArray = color2BinaryString[i].toCharArray();
			
			for (int j=0; j<color1BinaryString[i].length(); j++)
			{
				int color3BitValue = 0;
				
				if (color1CharArray[j] != color2CharArray[j]) color3BitValue = 1;
				
				color3BinaryStringBuffer[i].append(String.valueOf(color3BitValue));
			}
		}
	
        xorColor = new Color(slider.getDisplay(), new RGB(Integer.parseInt(color3BinaryStringBuffer[0].toString(), 2), Integer.parseInt(color3BinaryStringBuffer[1].toString(), 2), Integer.parseInt(color3BinaryStringBuffer[2].toString(), 2)));
    }
    
    public void dispose()
    {
//indicator shouldnt dispose of this if it didnt create it    	
//    	if (color != null) color.dispose();
    	if (xorColor != null) xorColor.dispose();
    }
}    
    
