/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Collection Boundary</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A collection boundary (segment boundary) of a trace. This class marks the beginning of a segment. It can have an method invocation associated with it (the first method invocation that was received in that slice). The end of a segment is marked by the end of the trace or by the next segment.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastInvocation <em>Last Invocation</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastClass <em>Last Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastThread <em>Last Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastObject <em>Last Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastPackage <em>Last Package</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastMethod <em>Last Method</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getHeapDump <em>Heap Dump</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary()
 * @model 
 * @generated
 */
public interface TRCCollectionBoundary extends AbstractTRCCollectionBoundary{
	/**
	 * Returns the value of the '<em><b>Last Invocation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Invocation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Points to the first method invocation (if exists) that was received in this collection boundary.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Last Invocation</em>' reference.
	 * @see #setLastInvocation(TRCMethodInvocation)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_LastInvocation()
	 * @model 
	 * @generated
	 */
	TRCMethodInvocation getLastInvocation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastInvocation <em>Last Invocation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Invocation</em>' reference.
	 * @see #getLastInvocation()
	 * @generated
	 */
	void setLastInvocation(TRCMethodInvocation value);

	/**
	 * Returns the value of the '<em><b>Process</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectionBoundaryPoints <em>Collection Boundary Points</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process</em>' container reference.
	 * @see #setProcess(TRCProcess)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_Process()
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getCollectionBoundaryPoints
	 * @model opposite="collectionBoundaryPoints" required="true"
	 * @generated
	 */
	TRCProcess getProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getProcess <em>Process</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process</em>' container reference.
	 * @see #getProcess()
	 * @generated
	 */
	void setProcess(TRCProcess value);

	/**
	 * Returns the value of the '<em><b>Last Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Class</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Class</em>' reference.
	 * @see #setLastClass(TRCClass)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_LastClass()
	 * @model 
	 * @generated
	 */
	TRCClass getLastClass();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastClass <em>Last Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Class</em>' reference.
	 * @see #getLastClass()
	 * @generated
	 */
	void setLastClass(TRCClass value);

	/**
	 * Returns the value of the '<em><b>Last Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Thread</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Thread</em>' reference.
	 * @see #setLastThread(TRCThread)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_LastThread()
	 * @model 
	 * @generated
	 */
	TRCThread getLastThread();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastThread <em>Last Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Thread</em>' reference.
	 * @see #getLastThread()
	 * @generated
	 */
	void setLastThread(TRCThread value);

	/**
	 * Returns the value of the '<em><b>Last Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Object</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Object</em>' reference.
	 * @see #setLastObject(TRCObject)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_LastObject()
	 * @model 
	 * @generated
	 */
	TRCObject getLastObject();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastObject <em>Last Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Object</em>' reference.
	 * @see #getLastObject()
	 * @generated
	 */
	void setLastObject(TRCObject value);

	/**
	 * Returns the value of the '<em><b>Last Package</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Package</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Package</em>' reference.
	 * @see #setLastPackage(TRCPackage)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_LastPackage()
	 * @model 
	 * @generated
	 */
	TRCPackage getLastPackage();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastPackage <em>Last Package</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Package</em>' reference.
	 * @see #getLastPackage()
	 * @generated
	 */
	void setLastPackage(TRCPackage value);

	/**
	 * Returns the value of the '<em><b>Last Method</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Method</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Method</em>' reference.
	 * @see #setLastMethod(TRCMethod)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_LastMethod()
	 * @model 
	 * @generated
	 */
	TRCMethod getLastMethod();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getLastMethod <em>Last Method</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Method</em>' reference.
	 * @see #getLastMethod()
	 * @generated
	 */
	void setLastMethod(TRCMethod value);

	/**
	 * Returns the value of the '<em><b>Heap Dump</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Heap Dump</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Heap Dump</em>' reference.
	 * @see #setHeapDump(TRCHeapDump)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCollectionBoundary_HeapDump()
	 * @model 
	 * @generated
	 */
	TRCHeapDump getHeapDump();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getHeapDump <em>Heap Dump</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Heap Dump</em>' reference.
	 * @see #getHeapDump()
	 * @generated
	 */
	void setHeapDump(TRCHeapDump value);

} // TRCCollectionBoundary
