/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Trace Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl#getThread <em>Thread</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCTraceObjectImpl extends TRCObjectImpl implements TRCTraceObject {
	/**
	 * The cached value of the '{@link #getInvocations() <em>Invocations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocations()
	 * @generated
	 * @ordered
	 */
	protected EList invocations = null;

	/**
	 * The cached value of the '{@link #getThread() <em>Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread thread = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCTraceObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCTraceObject();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInvocations() {
		if (invocations == null) {
			invocations = new EObjectResolvingEList(TRCMethodInvocation.class, this, TracePackage.TRC_TRACE_OBJECT__INVOCATIONS);
		}
		return invocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getThread() {
		if (thread != null && thread.eIsProxy()) {
			TRCThread oldThread = thread;
			thread = (TRCThread)eResolveProxy((InternalEObject)thread);
			if (thread != oldThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_TRACE_OBJECT__THREAD, oldThread, thread));
			}
		}
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetThread() {
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setThread(TRCThread newThread) {
		TRCThread oldThread = thread;
		thread = newThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TRACE_OBJECT__THREAD, oldThread, thread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_TRACE_OBJECT__IS_A:
					if (isA != null)
						msgs = ((InternalEObject)isA).eInverseRemove(this, TracePackage.TRC_CLASS__OBJECTS, TRCClass.class, msgs);
					return basicSetIsA((TRCClass)otherEnd, msgs);
				case TracePackage.TRC_TRACE_OBJECT__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_TRACE_OBJECT__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_TRACE_OBJECT__IS_A:
					return basicSetIsA(null, msgs);
				case TracePackage.TRC_TRACE_OBJECT__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_TRACE_OBJECT__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_TRACE_OBJECT__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__OBJECTS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TRACE_OBJECT__ID:
				return new Long(getId());
			case TracePackage.TRC_TRACE_OBJECT__SIZE:
				return new Integer(getSize());
			case TracePackage.TRC_TRACE_OBJECT__IS_A:
				if (resolve) return getIsA();
				return basicGetIsA();
			case TracePackage.TRC_TRACE_OBJECT__PROCESS:
				return getProcess();
			case TracePackage.TRC_TRACE_OBJECT__INVOCATIONS:
				return getInvocations();
			case TracePackage.TRC_TRACE_OBJECT__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TRACE_OBJECT__ID:
				setId(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_TRACE_OBJECT__SIZE:
				setSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_TRACE_OBJECT__IS_A:
				setIsA((TRCClass)newValue);
				return;
			case TracePackage.TRC_TRACE_OBJECT__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_TRACE_OBJECT__INVOCATIONS:
				getInvocations().clear();
				getInvocations().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_TRACE_OBJECT__THREAD:
				setThread((TRCThread)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TRACE_OBJECT__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_TRACE_OBJECT__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_TRACE_OBJECT__IS_A:
				setIsA((TRCClass)null);
				return;
			case TracePackage.TRC_TRACE_OBJECT__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_TRACE_OBJECT__INVOCATIONS:
				getInvocations().clear();
				return;
			case TracePackage.TRC_TRACE_OBJECT__THREAD:
				setThread((TRCThread)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TRACE_OBJECT__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_TRACE_OBJECT__SIZE:
				return size != SIZE_EDEFAULT;
			case TracePackage.TRC_TRACE_OBJECT__IS_A:
				return isA != null;
			case TracePackage.TRC_TRACE_OBJECT__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_TRACE_OBJECT__INVOCATIONS:
				return invocations != null && !invocations.isEmpty();
			case TracePackage.TRC_TRACE_OBJECT__THREAD:
				return thread != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCTraceObjectImpl
