package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The FeatureSituation deals with the situations that announce that a feature 
 * of a component is now ready (or not ready) for service requests. Situations 
 * that indicate things like services being available and services or features 
 * being unavailable fall into this category. Existing situations include words 
 * like now available, currently available, and transport is listening on port 
 * 123, for example:
 * 
 * <code>
 * SRVE0171I: Transport HTTPS is listening on port 9443
 * MSGS0601I: WebSphere Embedded Messaging has not been installed
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see IFeatureSituation
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class FeatureSituationImpl extends SituationTypeImpl implements IFeatureSituation, Serializable, Cloneable {

    //Define the serialiVersionUID for serialization:
    //NOTE: If this object is ever changed which breaks backward compatibility,
    //this value MUST be changed.  Every effort should be made not to break 
    //backward compatibility.
    static final long serialVersionUID = -3888096669772662967L;

    //Define the fields that will be serialized: 
    //NOTE: If any new variables are added to the class this table should be 
    //updated along with the readObject and writeObject methods.
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("featureDisposition", String.class)};

    //Class instance variable(s):
    protected String featureDisposition = null;

    /**
     * No-argument protected constructor for ReportSituationImpl.
     */
    protected FeatureSituationImpl() {
		super();
    }

    /**
    * Returns the featureDisposition.
    * 
    * This property specifies the availability disposition of a feature 
    * of a component that caused the situation to be reported.
    * The featureDisposition is a string with the following set of values:
    * 
    * AVAILABLE
    * NOT AVAILABLE
    * 
    * This is a REQUIRED property and once it is set it MUST NOT change. 
    * The string length for this property MUST NOT exceed 64 characters.
    * 
    * @return String The returned featureDisposition.
    * @since 1.0.1
    */
    public String getFeatureDisposition() {
        return featureDisposition;
    }

    /**
     * Sets the featureDisposition.
     * 
     * This property specifies the availability disposition of a feature 
     * of a component that caused the situation to be reported.
     * The featureDisposition is a string with the following set of values:
     * 
     * AVAILABLE
     * NOT AVAILABLE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param featureDisposition The featureDisposition to be set.
     * @since 1.0.1
     */
    public void setFeatureDisposition(String featureDisposition) {
        this.featureDisposition = featureDisposition;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        //Check if the parameter object's super class is equal to the this object's super class:
        if (super.equals(object)) {

            //Compare the value(s) of all object properties:
            String thisObjectsProperty = getFeatureDisposition();
            String parameterObjectsProperty = ((FeatureSituationImpl) (object)).getFeatureDisposition();

            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null)))
                return true;
        }

        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {

        //Set the values of the serializable field(s):
        ObjectOutputStream.PutField fields = out.putFields();

        fields.put("featureDisposition", featureDisposition);

        //Write the values of the serializable field(s):
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

        //Prepare and read the alternate persistent field(s):
        ObjectInputStream.GetField fields = null;

        fields = in.readFields();

        //Retrieve the alternate persistent field(s):
        featureDisposition = ((String) (fields.get("featureDisposition", featureDisposition)));
    }

    /**
     * Return a clone (copy by value) of this object. This is a deep copy version, 
     * in which all the objects within this object will be copied by value.
     *  
     * @return Object The clone of this object.
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.ISituationType#init()
     */
    public void init() {

        super.init();

        featureDisposition = null;
    }
}