package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.hyades.logging.events.exceptions.InvalidXMLAnyElementException;

/**
 * @author Jason Cornpropst
 *
 * This is a generic interface that is used to store the any elements
 * that may be associated with a common base event. This will allow 
 * the event to store the any element and not throw it away if the event factory
 * does not have a specific implementation for the any element.
 * 
 * @version 1.0
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface ICommonBaseEventAnyElement
{
    /**
     * This method returns the URI that points to the schema that this 
     * any element implements
     * 
     * @return String 
     */
    public String getNameSpace();
         
    /**
     * Method to retrieve the identifier used for the name space
     * 
     * @return String
     */
    public String getNameSpaceIdentifier();
      
    /**
     * Method to retrieve the name of the element
     * 
     * @return String
     */
    public String getElementName();
      
    /**
     * Method to return the any element in XML format
     * This method should return the full element including name space declaration
     * 
     * @return String
     */
    public String getXmlAnyElement();
    
    /**
     * Method to set the XML any element
     * 
     * @param String a xml element as a String
     * 
     * @throws InvalidXMLAnyElementException If an inavlid element is passed in.
     */
    public void setXmlAnyElement(String anyElement) throws InvalidXMLAnyElementException;
    
}
