/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author jtoomey
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class HyadesTPFTestSuiteAdapter extends AdapterImpl {

	/**
	 * 
	 */
	public HyadesTPFTestSuiteAdapter() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object arg0) {
	  if (arg0 instanceof EObject)
	  {
		return ((EObject)arg0).eClass() == Common_TestprofilePackage.eINSTANCE.getTPFTestSuite();
	  }
	  return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
				
		int eventType = notification.getEventType();
			
		if ( eventType == Notification.ADD ||
			 eventType == Notification.ADD_MANY ||
			 eventType == Notification.REMOVE ||
			 eventType == Notification.REMOVE_MANY )
		{
			TPFTestSuiteImpl suite = (TPFTestSuiteImpl) notification.getNotifier();
			if(!FacadeResourceFactoryImpl.PERSISTENCE_ID.equals(suite.getPersistenceId()))
			{
				return;
			}
			Iterator iter = null;
			switch (notification.getFeatureID(TPFTestSuite.class))
			{
				case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
					IImplementor implementor = ((ITestSuite)suite).getImplementor();
					IBlock block = null;
					if(implementor != null)
					{
						block = implementor.getBlock();
					}
					CFGClassImpl sut = null;
					TPFSUTImpl systemUnderTest = null;
					List systemsUnderTest = null;
					int numOfInstances = 0;

					switch(eventType){
						case Notification.ADD:
							systemUnderTest = (TPFSUTImpl)notification.getNewValue();
						
							sut = (CFGClassImpl)systemUnderTest;
							if(sut.getInstances().size() > 0)
							{
								if(((CFGInstanceImpl)sut.getInstances().get(0)).getLifeline() == null)
								{
									if(block != null)
									{
										BVRLifelineImpl lifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
										((CFGInstanceImpl)sut.getInstances().get(0)).setLifeline(lifeline);
										((BVRInteractionImpl)block).getLifelines().add(lifeline); 
									}
								}
							}	
							break;			
						case Notification.ADD_MANY:
							systemsUnderTest = (List)notification.getNewValue();
							iter = systemsUnderTest.iterator();
							while (iter.hasNext()) {							
								sut = (CFGClassImpl)iter.next();
								if(sut.getInstances().size() > 0)
								{
									if(((CFGInstanceImpl)sut.getInstances().get(0)).getLifeline() == null)
									{
										if(block != null)
										{
											BVRLifelineImpl lifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
											((CFGInstanceImpl)sut.getInstances().get(0)).setLifeline(lifeline);
											((BVRInteractionImpl)block).getLifelines().add(lifeline); 
										}
									}
								}	
							}
							
							break;
						case Notification.REMOVE:
							systemUnderTest = (TPFSUTImpl)notification.getOldValue();
							sut = (CFGClassImpl)systemUnderTest;
							
							// go through instances of the SUT, get the lifeline, and remove it from the interaction
							numOfInstances = sut.getInstances().size();							
							for(int i = 0; i < numOfInstances; i++)
							{
								BVRLifelineImpl lifeline = (BVRLifelineImpl)((CFGInstanceImpl)sut.getInstances().get(i)).getLifeline();
								lifeline.getInteraction().getLifelines().remove(lifeline);
								sut.getInstances().remove(i); 
							}							
							break;
						case Notification.REMOVE_MANY:
							systemsUnderTest = (List)notification.getOldValue();
							iter = systemsUnderTest.iterator();
							while (iter.hasNext()) {							
								sut = (CFGClassImpl)iter.next();

								// go through instances of the SUT, get the lifeline, and remove it from the interaction
								numOfInstances = sut.getInstances().size();							
								for(int i = 0; i < numOfInstances; i++)
								{
									BVRLifelineImpl lifeline = (BVRLifelineImpl)((CFGInstanceImpl)sut.getInstances().get(i)).getLifeline();
									lifeline.getInteraction().getLifelines().remove(lifeline);
									sut.getInstances().remove(i); 
								}							
							}
							break;					
					}
					break;
				
				case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:			
					break;
				case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
					break;

			}
		
		}
	}
	
	BVRLifeline getSUTLifelineFromBlock( CFGClassImpl sut, BVRInteractionImpl block )
	{
		List lifelines = block.getLifelines();
		Iterator it = lifelines.iterator();
		
		BVRLifelineImpl retLifeline = null, tempLifeline = null;
		while ( it.hasNext() )
		{
			tempLifeline = (BVRLifelineImpl) it.next();
			CFGInstanceImpl instance = (CFGInstanceImpl)tempLifeline.getInstances().get(0);
			if (((CFGClassImpl)instance.getClassOwner()).equals(sut))
			{
				retLifeline = tempLifeline;
				break;
			}
		}
		return retLifeline;		
	}

}
