/**********************************************************************
 * Copyright (c) 2003-2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.*;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.trace.views.internal.CoverageStatistic;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

/**
 * @author hind.hasnaoui@fr.ibm.com  --
 *
 * The Coverage Page activates the method coverage analysis and displays the results 
 */
public class CoveragePage extends TraceViewerPage {

	protected CoverageStatistic _view;
	protected CoverageAnalysis _covAnalysis;

	public CoveragePage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}

	/**
	 * refresh the content of the page when the "RefreshViews"
	 * command is activated
	 */
	public void refreshPage() {
		// If no data to display -> compute method coverage
		if (getCovAnalysis().getRoot() == null ||
			getMOFObject() != getCovAnalysis().getRoot().getTraceObj()) {
			computeMethodCoverage();
			_view.update();
			_view.updateButtons();
			getView().refresh();
		}
	}

	/**
	 * the same element must be selected in all the statistics views
	 */
	public void selectionChanged() {
		_view.selectionChanged();
	}

	/**
	 * update the content of the page
	 */
	public void update(boolean newPage) {
		if (newPage) {
			_view.updateUI(_view.getColumnDataList());
		}
	}

	/**
	 * the control is used by the viewer to display this page
	 */
	public Control getControl() {
		return _view.getControl();
	}

	/**
	 * set the focus on the view
	 */
	public void setFocus() {
		getControl().setFocus();
		_view.showNewSelection();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/1/2001 6:31:38 PM)
	 * @return org.eclipse.jface.action.Action
	 */
	public Action openSource() {
		return ((CoverageViewer)_viewer).openSource();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:54:24 PM)
	 */
	public void makeActions()
	{
		_viewer.makeActions();
	}

	/**
	 * This method :
	 * - activates the method coverage analysis
	 * - displays the results and add a contextual menu 
	 */
	public void createControl(Composite parent) {
		//Compute data
		computeMethodCoverage();

		//Display data
		_view = displayData(parent);

		//Contextual menu
		setContextMenu(_view.getTable(), _view.getTableViewer());
		makeActions();

		//TODO: What's the help reference for coverage?
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			this.getControl(),
			TraceUIPlugin.getPluginId()+".clst0000");
	}

	/**
	 * compute the method coverage by creating an instance of
	 * the CoverageAnalysis class
	 *
	 */
	private void computeMethodCoverage() {
		setCovAnalysis(new CoverageAnalysis(getMOFObject()));
	}

	/**
	 * display the coverage data by creating an instance
	 * of the CoverageStatistic class
	 * 
	 */
	private CoverageStatistic displayData(Composite parent) {
		//	Reset the preferences.
		TraceUIPlugin.getDefault().getPreferenceStore().setValue(
			TraceUIPlugin.getString("PREFERENCE_KEY"),
			"");

		// Let's save the level and load it in the new instance
		CoverageStatistic view = new CoverageStatistic(parent, this);
		return view;
	}

	/**
	 * disposes the CoverageStatistic view
	 */
	public void dispose() {
		if (_view != null && _view.getControl() != null)
			super.dispose();

		//dispose method of the CoverageStatistic class
		if (_view != null) {
			_view.dispose();
		}

		_view = null;

	}

	/**
	 * @return the CoverageAnalysis instance
	 */
	public CoverageAnalysis getCovAnalysis() {
		return _covAnalysis;
	}

	/**
	 * @param the CoverageAnalysis instance
	 */
	public void setCovAnalysis(CoverageAnalysis analysis) {
		_covAnalysis = analysis;
	}

	/**
	 * Contribute to the view popup menu
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}

	/**
	 * @return the CoverageStatistic instance
	 */
	public CoverageStatistic getView() {
		return _view;
	}

	/**
	 * @return the Package level action
	 */
	public Action getPackageLevel() {
		return ((CoverageViewer) _viewer).getPackageLevel();
	}

	/**
	 * @return the Method Level action
	 */
	public Action getMethodLevel() {
		return ((CoverageViewer) _viewer).getMethodLevel();
	}

	/**
	 * @return the Class level action
	 */
	public Action getClassLevel() {
		return ((CoverageViewer) _viewer).getClassLevel();
	}
	
	public boolean isEmpty()
	{
		return _view.isEmpty();
	}

}
