/*
 * Created on Mar 15, 2004
 *
 */
package org.eclipse.hyades.internal.collection.framework;

import java.net.Socket;

import org.eclipse.hyades.execution.security.IClientHandler;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.local.common.Constants;

/**
 * @author Giridhar.S
 *
 */
public class FileConnectionHandlerImpl implements IConnectionHandler, Constants, FileServiceConstants {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.security.IConnectionHandler#connectionAccepted(java.net.Socket)
	 */
	public void connectionAccepted(Socket s) {

			/* Create a new clientHandler thread for each request that comes along, and pass the socket to the
			   client handler. The client handler thread reads the information sent by the client, and performs the 
			   file transfer. */
		
			IClientHandler clientHandler = new FileClientHandlerImpl(s);
			((FileClientHandlerImpl)clientHandler).setDaemon(true);
			((FileClientHandlerImpl)clientHandler).start();
	}
}