/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.test.data.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.test.data.DataPackage;
import org.eclipse.hyades.models.test.data.TSTDataPool;
import org.eclipse.hyades.models.test.data.TSTEquivalenceClass;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TST Data Pool</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.test.data.impl.TSTDataPoolImpl#getTestSuites <em>Test Suites</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.test.data.impl.TSTDataPoolImpl#getEquivalenceClasses <em>Equivalence Classes</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TSTDataPoolImpl extends EObjectImpl implements TSTDataPool {
	/**
	 * The cached value of the '{@link #getTestSuites() <em>Test Suites</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestSuites()
	 * @generated
	 * @ordered
	 */
	protected EList testSuites = null;

	/**
	 * The cached value of the '{@link #getEquivalenceClasses() <em>Equivalence Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquivalenceClasses()
	 * @generated
	 * @ordered
	 */
	protected EList equivalenceClasses = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TSTDataPoolImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DataPackage.eINSTANCE.getTSTDataPool();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTestSuites() {
		if (testSuites == null) {
			testSuites = new EObjectResolvingEList(TPFTestSuite.class, this, DataPackage.TST_DATA_POOL__TEST_SUITES);
		}
		return testSuites;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getEquivalenceClasses() {
		if (equivalenceClasses == null) {
			equivalenceClasses = new EObjectContainmentWithInverseEList(TSTEquivalenceClass.class, this, DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES, DataPackage.TST_EQUIVALENCE_CLASS__DATA_POOL);
		}
		return equivalenceClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES:
					return ((InternalEList)getEquivalenceClasses()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES:
					return ((InternalEList)getEquivalenceClasses()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DataPackage.TST_DATA_POOL__TEST_SUITES:
				return getTestSuites();
			case DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES:
				return getEquivalenceClasses();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DataPackage.TST_DATA_POOL__TEST_SUITES:
				getTestSuites().clear();
				getTestSuites().addAll((Collection)newValue);
				return;
			case DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES:
				getEquivalenceClasses().clear();
				getEquivalenceClasses().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DataPackage.TST_DATA_POOL__TEST_SUITES:
				getTestSuites().clear();
				return;
			case DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES:
				getEquivalenceClasses().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DataPackage.TST_DATA_POOL__TEST_SUITES:
				return testSuites != null && !testSuites.isEmpty();
			case DataPackage.TST_DATA_POOL__EQUIVALENCE_CLASSES:
				return equivalenceClasses != null && !equivalenceClasses.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //TSTDataPoolImpl
