/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Apr 13, 2004
 *
 */
package org.eclipse.hyades.log.ui.internal.actions;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * @author apnan
 *
 */
public class SaveAction
		extends
			org.eclipse.hyades.trace.ui.internal.actions.SaveAction {
	
	public SaveAction(INavigator viewer) {
		super(viewer);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.actions.SelectionProviderAction#getSelection()
	 */
	public ISelection getSelection() {
		INavigator viewer = getViewer();
		ISelection sel = viewer.getViewer().getSelection();
		List selObjects =  new UniqueEList();
		if(sel!=null && sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty()){
			List selection = ((IStructuredSelection)sel).toList();
			Object item = null;
			
			for(int i=0;i<selection.size();i++){
				item = selection.get(i);
				if(item instanceof LogicalFolder)
					selObjects.addAll(((LogicalFolder)item).getChildren());
				else
					selObjects.add(item);
			}
			return new StructuredSelection(selObjects);
		}		
		return sel;
	}
}
