/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;

import org.eclipse.jface.preference.IPreferenceStore;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class FilterTableElement
{
	public static final String P_OPERATOR= "operator_combo";
	public static final String P_ATTRIBUTE= "attribute_combo";
	public static final String P_VALUE= "value_string";	
	
	private String fAttribute;
	private String fOperator;	
	private String fValue;

	private FilterList fParent;

	public FilterTableElement(String attribute, String operator, String value) {
        fAttribute = attribute;		
		fOperator = operator;
		fValue = value;		
	}

    public void setParent(FilterList parent) {
    	fParent = parent;
    }
    
	public String getAtrribute() {
		return fAttribute;
	}	
	public String getOperator() {
		return fOperator;
	}
	public String getValue() {
		return fValue;
	}

	public int getAttributeState() {
		for(int idx=0; idx<CBEAdvFilterUI.fAttributeValues.length; idx++)
		{
		  if(CBEAdvFilterUI.fAttributeValues[idx].equals(fAttribute))
			return idx;
		}
		return -1;
	}
	public int getOperatorState() {
		for(int idx=0; idx<CBEAdvFilterUI.fOperatorValues.length; idx++)
		{
		  if(CBEAdvFilterUI.fOperatorValues[idx].equals(fOperator))
		    return idx;
		}
		return -1;
	}

	public void setValue(String value) {
		fValue= value;
		fParent.fireElementChanged(this, P_VALUE);				
	}
	
	public void setOperator(String value) {
		fOperator= value;
		fParent.fireElementChanged(this, P_OPERATOR);				
	}
	
	public void setOperator(int value) {
		fOperator= CBEAdvFilterUI.fOperatorValues[value];
		fParent.fireElementChanged(this, P_OPERATOR);				
	}
	
	public void setAttribute(String value) {
		fAttribute= value;
		fParent.fireElementChanged(this, P_ATTRIBUTE);				
	}
	
	public void setAttribute(int value) {
		fAttribute= CBEAdvFilterUI.fAttributeValues[value];
		fParent.fireElementChanged(this, P_ATTRIBUTE);				
	}
	
	public String toString() {
		return (fAttribute + "," + fOperator + "," + fValue);
	}
	
	public static ArrayList createFilterTableElementFromString(String preferenceColumns) {

	ArrayList filterTableElemList=null;	
	
	if (preferenceColumns != null && !preferenceColumns.equals("")) {
			
		// Walk the data and count how many columns the table should have
		// and then allocate the column ArrayList using that size.			
		int count = 0;
		for (int i = preferenceColumns.indexOf("!"); i != -1; i = preferenceColumns.indexOf("!",i+1)) {
			count++;
		}
		
		filterTableElemList = new ArrayList(count);
		
		// Walk the data again parsing each column data template and adding it
		// to the column data array list.
		int idx = 0;
		String filterDataTemplate;
		while (idx != -1) {
			idx = preferenceColumns.indexOf("!");
				
			if (idx != -1) {
				// For all but the last column definition
				filterDataTemplate = preferenceColumns.substring(0, idx);
				preferenceColumns = preferenceColumns.substring(idx + 1);
				addFilterData(filterDataTemplate, filterTableElemList);
			}
		}
	}
	return filterTableElemList;
}

	private static void addFilterData(String filterTemplate, ArrayList list) {
	
		String filterAttribute = "";
		String filterOperator = "";
		String filterValue = "";
			
		// Parse off the column name.
		int idx = filterTemplate.indexOf(";");
		if (idx != -1) {
			filterAttribute = filterTemplate.substring(0, idx);
			filterTemplate = filterTemplate.substring(idx + 1);
		
			idx = filterTemplate.indexOf(";");
			if (idx != -1) {
				filterOperator = filterTemplate.substring(0, idx);
				filterValue = filterTemplate.substring(idx + 1);
			}
		}
		list.add(new FilterTableElement(filterAttribute, filterOperator, filterValue));
	}

	public static boolean saveFilters(ArrayList currentList, String preferenceKey, IPreferenceStore store) {
		String filterAttribute = "";
		String filterOperator = "";
		String filterValue = "";
			
		// Create the column data template string to save in the preferences store
		String filtersString = "";
		for (int i = 0; i < currentList.size(); i++) {
			FilterTableElement filterData = (FilterTableElement)currentList.get(i);
			filterAttribute = filterData.getAtrribute();
			filterOperator = filterData.getOperator();
			filterValue = filterData.getValue();
			
			filtersString = filtersString + filterAttribute+";"+filterOperator+";"+filterValue+"!";			
		}
		
		if (filtersString!="")
			filtersString.substring(0,filtersString.length()-1);
		
		boolean filterChanged = !store.getString(preferenceKey).equals(filtersString);
		// Save the column data template into the preferences.
		store.setValue(preferenceKey, filtersString);
		return filterChanged;
	}
	
}