/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
/**
 * @author slavescu
 */
public class LargeResourceSupportUI implements SelectionListener {

//	private Combo selectDriver;
	protected Text username;
	protected Text password;
	protected Text cacheSize;
	protected Composite container;
	protected Combo storeType;

	public LargeResourceSupportUI() {
		super();
		
	}
	public Control createControl(Composite parent) {
				
		container = new Composite(parent,SWT.NONE);
		container.setLayoutData(GridDataUtil.createFill());
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 2;
		container.setLayout(layout);
		
		Label lDBType = new Label(container, SWT.NONE);
		lDBType.setText(LogUIPlugin.getResourceString("LRSP_STORE_TYPE"));
		
		storeType = new Combo(container,SWT.BORDER | SWT.READ_ONLY);
		storeType.setLayoutData(GridDataUtil.createHorizontalFill());
		
		initPossibleDBType();
		
		Label lUsername = new Label(container, SWT.NONE);
		lUsername .setText(LogUIPlugin.getResourceString("LRSP_DB_USERNAME"));
		
		username = new Text(container,SWT.BORDER);
		username.setLayoutData(GridDataUtil.createHorizontalFill());
		
		Label lPassword = new Label(container, SWT.NONE);
		lPassword.setText(LogUIPlugin.getResourceString("LRSP_DB_PASSWORD"));

		password = new Text(container,SWT.BORDER);
		password.setEchoChar('*');
		password.setLayoutData(GridDataUtil.createHorizontalFill());

		Label lCacheSize = new Label(container, SWT.NONE);
		lCacheSize.setText(LogUIPlugin.getResourceString("LRSP_CACHE_SIZE"));
		cacheSize = new Text(container,SWT.BORDER);
		cacheSize.setLayoutData(GridDataUtil.createHorizontalFill());
		
		Button createTables = new Button(container,SWT.NONE);
		createTables.setText(LogUIPlugin.getResourceString("LRSP_CREATE_TABLES"));
		createTables.addMouseListener(new MouseListener(){
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseDoubleClick(MouseEvent e) {
				// TODO Auto-generated method stub

			}
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseDown(MouseEvent e) {
				// TODO Auto-generated method stub
			}
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseUp(MouseEvent e) {
//				System.out.println("LargeResourceSupportUI.createControl()");
				IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get("__"+storeType.getText()+".trcadb");
				if(hyadesResourceFactory!=null)
				{
					hyadesResourceFactory.createTables(storeType.getText(),HyadesResourceExtensions.getInstance().getProperties());
				}
			}
		});
		Button dropTables = new Button(container,SWT.NONE);
		dropTables.setText(LogUIPlugin.getResourceString("LRSP_DROP_TABLES"));
		dropTables.addMouseListener(new MouseListener(){
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseDoubleClick(MouseEvent e) {
				// TODO Auto-generated method stub

			}
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseDown(MouseEvent e) {
				// TODO Auto-generated method stub
			}
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseUp(MouseEvent e) {
//				System.out.println("LargeResourceSupportUI.createControl()");
				IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get("__"+storeType.getText()+".trcadb");
				if(hyadesResourceFactory!=null)
				{
					hyadesResourceFactory.dropTables(storeType.getText(),HyadesResourceExtensions.getInstance().getProperties());
				}
			}
		});

		initializeValues(false);
//		WorkbenchHelp.setHelp(username, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_ERROR);
//		WorkbenchHelp.setHelp(password, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_WARNING);

		return container;
	}

//	private String getStorePostfix(String dbType)
//	{
//		for(Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();iter.hasNext();)
//		{
//			Map.Entry entry = (Map.Entry)iter.next();
//			String postfix = (String)entry.getKey();
//			IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)entry.getValue();
//			if(hyadesResourceFactory != null && hyadesResourceFactory.isEnabledFor(postfix))
//			{
//				storeType.add(hyadesResourceFactory.getStoreType(postfix));
//				if(hyadesResourceFactory.getStoreType(postfix).equals(dbType))
//					return postfix;
//			}
//		}
//		return null;
//	}
	
	private void initPossibleDBType() {
		String defaultDBType = LogUIPlugin.getDefault().getPreferenceStore().getString(IHyadesResourceFactory.LARGE_RESOURCE_SUPPORT_DB_TYPE);
		int index=-1;
		int i=0;
		for(Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();iter.hasNext();)
		{
			Map.Entry entry = (Map.Entry)iter.next();
			String postfix = (String)entry.getKey();
			IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)entry.getValue();
			if(hyadesResourceFactory != null && hyadesResourceFactory.isEnabledFor(postfix))
			{
				storeType.add(hyadesResourceFactory.getStoreType(postfix));
				if(hyadesResourceFactory.getStoreType(postfix).equals(defaultDBType))
					index=i;
				i++;
			}
		}
		if(index!=-1)
			storeType.select(index);
		
	}
	public void initializeValues(boolean defaultValue) {
				
		Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
		
		String s = defaultValue ? store.getDefaultString(IHyadesResourceFactory.LRSP_USERNAME):store.getString(IHyadesResourceFactory.LRSP_USERNAME);
		if(s!=null)
			username.setText(s);
		s = defaultValue ? store.getDefaultString(IHyadesResourceFactory.LRSP_PASSWORD):store.getString(IHyadesResourceFactory.LRSP_PASSWORD);
		if(s!=null)
			password.setText(s);
		s = defaultValue ? store.getDefaultString(IHyadesResourceFactory.LARGE_RESOURCE_SUPPORT_DB_TYPE):store.getString(IHyadesResourceFactory.LARGE_RESOURCE_SUPPORT_DB_TYPE);
		if(s!=null)
			storeType.setText(s);
		
	}
	
	public boolean storeValues() {
		Preferences newStore = HierarchyPlugin.getPlugin().getPluginPreferences();
		newStore.setValue(IHyadesResourceFactory.LARGE_RESOURCE_SUPPORT_DB_TYPE, storeType.getText());
		newStore.setValue(IHyadesResourceFactory.LRSP_USERNAME, username.getText());
		newStore.setValue(IHyadesResourceFactory.LRSP_PASSWORD, password.getText());
		newStore.setValue(IHyadesResourceFactory.LRSP_CACHE_SIZE, cacheSize.getText());
		return true;
	}

	/**
	 * @return Composite
	 */
	public Composite getControl() {
		return container;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
		// do nothing
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		// do nothing
	}

}