/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class LogUtil {
	
	public static boolean selectInLogNavigator(EObject object) {
		if (object!=null) {
			Navigator nav = (Navigator)HyadesUtil.getActiveNavigator();
			IViewPart part = null;

			IWorkbench workbench = LogUIPlugin.getDefault().getWorkbench();
			IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
			
			if(!(nav instanceof LogNavigator)){
				try {
					if(page != null && !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) ){
						IAdaptable element =
						ResourcesPlugin.getWorkspace().getRoot();
						if (element != null)
							page =
								workbench.showPerspective(
									PDPerspective.ID_TRACE_PERSPECTIVE,
									workbench.getActiveWorkbenchWindow(),
									element);
									
					}
					part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);

				} catch (Exception e) {
					
					e.printStackTrace();
				}
						
			}else{		
				part = nav;
			}
			
			final EObject selection = object;
			final IViewPart fPart = part;
			
			final IWorkbenchPage fPage = page;
			if(fPart!=null){

				Display.getDefault().asyncExec(new Runnable()
				{
					public void run()
					{						
						((LogNavigator)fPart).selectReveal(new StructuredSelection(selection));
						if(!((LogNavigator)fPart).isActiveNavigator()){
							try{	
								fPage.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
							}
							catch(Exception e){
								e.printStackTrace();
							}
						}
					}
				});						
			}
		}
		return false;
	}

	public static void notifyViewSelectionChanged(Object source, Object selection) {
		UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).add(selection);
			
		ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
		event.setSource(source);
		UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
	}
}
