/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import java.util.Iterator;

import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 */
public class GoToCalled implements IViewActionDelegate {
	
	protected SDView viewer = null;

	public void init (IViewPart view)
	{
		if (view instanceof SDView)
			viewer = (SDView)view;
	}
	
	public void run (IAction action)
	{
		if (viewer == null)
			return;
		SDWidget sdWidget = viewer.getSDWidget();
		Frame frame = viewer.getFrame();
		if (frame==null || sdWidget==null)
			return;
		ISelectionProvider selProvider = sdWidget.getSelectionProvider();
		ISelection sel=selProvider.getSelection();
		Object selectedNode= null;
		Iterator  it = ((StructuredSelection)sel).iterator();
		while (it.hasNext())
		{
			Object node = it.next();
			if (node instanceof BaseMessage)
				selectedNode = node;
		}
		
		GraphNode node;
		if (selectedNode instanceof BaseMessage)
			node = frame.getCalledMessage((BaseMessage)selectedNode);
		else node = frame.getCalledMessage(null);
		if (node != null)
		{
			sdWidget.clearSelection();
			sdWidget.addSelection(node);
			sdWidget.ensureVisible(node);
//			sdWidget.setFocusNode(node);
			sdWidget.redraw();
		}
	}
	
	
	public void selectionChanged(IAction action, ISelection selection)
	{
	}
}
