/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFTypedEvent}.
 * 
 * @author kobylin
 * @author marcelop
 */
public class TypedEvent 
extends ExecutionEvent
{
	public static final int START = 0;
	public static final int STOP = 1;

	private int type = NOT_INITIALIZED_VALUE;

	/**
	 * Sets the type of this event.
	 * @param value
	 */
	public void setType(int value)
	{
		type = value;
	}

	/**
	 * Returns the type of this event.
	 * @return int
	 */
	public int getType()
	{
		return type;
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "typedEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		if(getType() != NOT_INITIALIZED_VALUE)
			xml.append((XMLUtil.createXMLAttribute("type", Integer.toString(getType()), false)).toString());
	}	
}
