/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (9/12/00 2:35:40 PM)
 * @author:
 */
public class CustomCommand extends SimpleAgentInfoCommand {

	protected RAString _data;
	protected RABinaryArray _binaryData;
/**
 * CustomCommand constructor comment.
 */
public CustomCommand() {
	super();
	_tag=RA_CUSTOM_COMMAND;
}
/**
 * Insert the method's description here.
 * Creation date: (2/20/01 11:23:17 PM)
 * @return java.lang.String
 */
public String getData() {
	if(_data!=null) {
		return _data.getData();
	}
	else if(_binaryData!=null) {
		return new String(_binaryData.getData(), 0);
	}
	return null;
}

public byte[] getDataBinary() {
	if(_binaryData!=null) {
		return _binaryData.getData();
	}
	else if(_data!=null) {
		return _data.getData().getBytes();
	}
	return null;
}

/**
 * getSize method comment.
 */
public int getSize() {
	if(_data!=null) {
		return super.getSize()+_data.getSize();
	}
	else if(_binaryData!=null) {
		return super.getSize()+_binaryData.getSize();
	}
	/* If neither of these are set, the minimum size is sizeofLong */
	return super.getSize()+sizeofLong;
}
/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);
	_binaryData=new RABinaryArray();
	current=Message.readRABinaryArrayFromBuffer(buffer, current, _binaryData);
	return current;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 8:20:52 PM)
 * @param data java.lang.String
 */
public void setData(String data) {
	if(_data==null) {
		_data=new RAString(data);
	}
	else {
		_data.setData(data);
	}
	_binaryData=null;
	
}

public void setData(byte[] data) {
	if(_binaryData==null) {
		_binaryData=new RABinaryArray(data);
	}
	else {
		_binaryData.setData(data);
	}
	_data=null;
}

/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
    int current;
    if(_data!=null) {
        current=super.writeToBuffer(buffer, offset);
        current=Message.writeRAStringToBuffer(buffer, current, _data);
    }
    else if(_binaryData!=null) {
		// By eliminating the change to the tag, the command type will remain unchanged, causing encoding problems
		// on platforms such as the 390 if custom commands are used inproperly as binary custom commands.
		// _tag=RA_BINARY_CUSTOM_COMMAND;
        current=super.writeToBuffer(buffer, offset);
        current=Message.writeRABinaryArrayToBuffer(buffer, current, _binaryData);
    }
    else {
        current=super.writeToBuffer(buffer, offset);
        current=Message.writeRAStringToBuffer(buffer, current, new RAString(""));
    }
    return current;
}
}
