/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (9/11/00 11:50:44 PM)
 * @author:
 */
public class RegisteredProcessListCommand extends CommandElement implements Constants {

	int _processListLength=0;
	long _processList[];
/**
 * QueryServerCommand constructor comment.
 */
public RegisteredProcessListCommand() {
	super();
	_tag=RA_PROCESS_LIST;
}
/**
 * Insert the method's description here.
 * Creation date: (9/12/00 12:14:34 AM)
 * @return long[]
 */
public long[] getProcessList() {
	return _processList;
}
/**
 * getSize method comment.
 */
public int getSize() {
	return 2*sizeofLong+sizeofLong*(1+_processListLength);
}
/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=offset;
	_context=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	
	_processListLength=(int)Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	
	_processList=new long[_processListLength];
	for(int i=0; i<_processListLength; i++) {
		_processList[i]=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
	}
	return current;
}
/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=offset;

	current=Message.writeRALongToBuffer(buffer, current, _tag);
	current=Message.writeRALongToBuffer(buffer, current, _context);

	current=Message.writeRALongToBuffer(buffer, current, (long)_processListLength);

	for(int i=0; i<_processListLength; i++) {
		current=Message.writeRALongToBuffer(buffer, current, _processList[i]);
	}
	return current;
}
}
