/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon;

import java.util.*;
import java.io.*;

public class ByteArrayInBuffer extends InputStream {

Object lock = new Object();

ArrayList bufs = new ArrayList();
int len = 0;

byte[] tmp = new byte[0];	
int ptr = 0;

Object notifier = new Object();	

boolean closed = false;
IOException ioexception = null;

	public ByteArrayInBuffer() {
	}

	public int length() {
		return len + (tmp.length-ptr);	
	}

	private void waitForData() {
		synchronized (notifier) {
			while(len <= 0) {
				try {
					notifier.wait();
				} catch (InterruptedException e) {}
			}
		}
	}
	
	public void setClosed() {
		closed = true;
	}
	public void setClosed(IOException t) {
		closed = true;
		ioexception = t;
	}

	public int read() throws IOException {
		if (closed && len == 0) {
			if (ioexception != null) throw ioexception;
			return -1;
		}
		
		get();

		return 0x000000FF & ((int)tmp[ptr++]);
	} 
	public int read(byte[] b) throws IOException {
		return read(b,0,b.length);
	} 
	public int read(byte[] b, int off, int length) throws IOException {
		if (closed && len == 0) {
			if (ioexception != null) throw ioexception;
			return -1;
		}
		
		get();

		int tmplen = tmp.length - ptr;
		
		if (tmplen <= length) {
			//buffer can take all available data
			System.arraycopy(tmp,ptr,b,off,tmplen);

			ptr+= tmplen;

			return tmplen;
		} else {
			//we can fill buffer
			System.arraycopy(tmp,ptr,b,off,length);
			
			ptr += length;
			
			return length;
		}
	}  

	private void get() {
		if (ptr >= tmp.length) {
			//this should really be ==
			waitForData();
			synchronized (lock) {
				tmp = (byte[])bufs.remove(0);
				len -= tmp.length;
				ptr = 0;
			}
		} 	
	}

	public void add(byte[] dat) {
		if (dat.length > 0) {
			byte[] ndat = new byte[dat.length];
			System.arraycopy(dat,0,ndat,0,dat.length);
			synchronized(lock) {
				bufs.add(ndat);
				len += ndat.length;
			}
			synchronized(notifier) {
				notifier.notify();
			}
		}
	}
	
}
